/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.integration.slicer;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gwe.integration.slicer.model.ExecutableModel;
import org.gwe.utils.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCLMProxyApp {
    public static String ENV_SLICER_HOME = "SLICER_HOME";
    public static String PLUGINS_RELATIVE_DIR = "/lib/Slicer3/Plugins";
    private static Class[] classes = new Class[]{String.class};
    protected String slicerHome = System.getenv(ENV_SLICER_HOME);
    protected ExecutableModel xmlModel = null;

    public static <PROXY_APP_TYPE extends AbstractCLMProxyApp> void mainIdBased(Class<PROXY_APP_TYPE> proxyAppClass, String[] args) throws Exception {
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.addAll(Arrays.asList(args));
        String proxyAppIdentifier = (String)argsList.remove(0);
        AbstractCLMProxyApp proxyApp = (AbstractCLMProxyApp)proxyAppClass.getConstructor(classes).newInstance(proxyAppIdentifier);
        AbstractCLMProxyApp.main(proxyApp, argsList);
    }

    public static <PROXY_APP extends AbstractCLMProxyApp> void main(PROXY_APP proxyApp, List<String> argsList) {
        String[] args = argsList.toArray(new String[0]);
        try {
            ExecutableModel model = new ExecutableModel(null, null, null);
            model.loadArgs(args, false);
            if (model.isXMLSelected()) {
                System.out.println(proxyApp.generateProxyXML());
            } else if (!model.isLogoSelected()) {
                try {
                    System.out.println("CLMP invoked with args: " + StringUtils.getArrayAsStr(args));
                    proxyApp.runProxyApp(args);
                }
                catch (RemoteException e) {}
            }
        }
        catch (Exception e) {
            System.out.println("CLMP invoked with args: " + StringUtils.getArrayAsStr(args));
            e.printStackTrace();
        }
    }

    public static String[] removeArgs(String[] args, int count) {
        String[] trimmedArgs = new String[args.length - count];
        for (int idx = count; idx < args.length; ++idx) {
            trimmedArgs[idx - count] = args[idx];
        }
        return trimmedArgs;
    }

    public String getPluginsDir() {
        return this.getPluginsDir(this.slicerHome);
    }

    public String getPluginsDir(String slicerHomeDir) {
        return slicerHomeDir + PLUGINS_RELATIVE_DIR;
    }

    public ExecutableModel getXmlModel() {
        return this.xmlModel;
    }

    public void setXmlModel(ExecutableModel xmlModel) {
        this.xmlModel = xmlModel;
    }

    public abstract String generateProxyXML() throws Exception;

    public abstract String runProxyApp(String[] var1) throws Exception;

    protected String generateCLMErrorXML(IOException e) {
        return "";
    }
}

