/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.integration.slicer;

import java.io.FileNotFoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwe.api.ServerAPIConnectionException;
import org.gwe.api.event.DefaultEventFilter;
import org.gwe.api.exceptions.GWEDomainException;
import org.gwe.api.exceptions.GridNotFoundException;
import org.gwe.api.exceptions.GridNotSpecifiedException;
import org.gwe.api.exceptions.OrderNotSpecifiedException;
import org.gwe.api.exceptions.PasswordMismatchException;
import org.gwe.app.client.ClusterNotSpecifiedException;
import org.gwe.app.client.XMLClientAppConfig;
import org.gwe.integration.slicer.AbstractCLMProxyApp;
import org.gwe.integration.slicer.GWECLMProxyAppEventListener;
import org.gwe.integration.slicer.SlicerResultParser;
import org.gwe.integration.slicer.WrapperCLMProxyApp;
import org.gwe.integration.slicer.model.GroupModel;
import org.gwe.integration.slicer.model.param.PMEnumString;
import org.gwe.integration.slicer.model.param.PMString;
import org.gwe.p2el.P2ELStatement;
import org.gwe.p2el.P2ELSyntaxException;
import org.gwe.persistence.model.HeadResourceInfo;
import org.gwe.persistence.model.OrderInfo;
import org.gwe.persistence.model.UserInfo;
import org.gwe.persistence.model.order.shell.VelocityJobsDescriptor;
import org.gwe.utils.IOUtils;
import org.gwe.utils.StringUtils;
import org.gwe.utils.VelocityUtils;
import org.gwe.utils.cmd.OptionableAppTemplate;
import org.gwe.utils.security.CredentialNotFoundException;

public class GWECLMProxyApp
extends AbstractCLMProxyApp {
    private static Log log = LogFactory.getLog(GWECLMProxyApp.class);
    private static String ERROR_FILTER_NAME = "<filter-name>Error Message</filter-name>";
    private OptionableAppTemplate template;
    private GroupModel settings;
    private PMEnumString optClusterDesc;
    private PMString optUserName;
    private PMString optUserPassw;
    private PMString optSlicerDir;
    private PMString optVariables;
    private XMLClientAppConfig appConfig;
    private WrapperCLMProxyApp proxiedModule;

    public static void main(String[] args) throws Exception {
        GWECLMProxyApp.mainIdBased(GWECLMProxyApp.class, args);
    }

    public GWECLMProxyApp(String proxiedModuleName) {
        this.proxiedModule = new WrapperCLMProxyApp(proxiedModuleName);
        try {
            this.appConfig = new XMLClientAppConfig(null, null);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (CredentialNotFoundException e) {
            e.printStackTrace();
        }
        catch (ClusterNotSpecifiedException e) {
            e.printStackTrace();
        }
        this.settings = new GroupModel("GWE Settings", "Slicer3 GWE Settings");
        ArrayList<String> clustersNamesList = new ArrayList<String>();
        for (HeadResourceInfo daemonInfo : this.appConfig.getGrid().getHeadResources()) {
            clustersNamesList.add(daemonInfo.getName());
        }
        String[] clustersNames = clustersNamesList.toArray(new String[0]);
        this.optClusterDesc = this.settings.addParam(new PMEnumString("Cluster", "gweCluster", "Name of the cluster descriptor to use to contact GWE daemon", null, clustersNames));
        this.optUserName = this.settings.addParam(new PMString("GWE User Name", "gweUserName", "GWE User Name"));
        this.optUserPassw = this.settings.addParam(new PMString("GWE User Password", "gweUserPassword", "GWE User Password"));
        this.optSlicerDir = this.settings.addParam(new PMString("Slicer Location", "gweSlicerLocation", "Directory on the cluster where to locate the slicer build - THIS SETTING WILL BE RELOCATED TO CLUSTER DESCRIPTOR!"));
        this.optVariables = this.settings.addParam(new PMString("Iteration Variables", "gweIterationVariables", "Variables to iterate to generate the commands to run in the cluster"));
        this.template = new OptionableAppTemplate(this.optClusterDesc, this.optUserName, this.optUserPassw, this.optSlicerDir, this.optVariables);
    }

    public String getRemoteSlicerLocation() {
        return this.template.getArg(this.optSlicerDir);
    }

    public String getIterVariables() {
        return this.template.getArg(this.optVariables);
    }

    public UserInfo getGWEUser() {
        return new UserInfo(this.template.getArg(this.optUserName), this.template.getArg(this.optUserPassw));
    }

    public String generateProxyXML() {
        String gweGroup = VelocityUtils.merge("group", this.settings, IOUtils.readClassPathFile("standardGroupModel.vm"));
        String proxyXML = this.proxiedModule.generateProxyXML().replaceFirst("<parameters>", gweGroup + "<parameters>");
        proxyXML = proxyXML.replaceAll("image>", "string>");
        proxyXML = proxyXML.replaceAll("<image ", "<string ");
        proxyXML = proxyXML.replaceAll("directory>", "string>");
        proxyXML = proxyXML.replaceAll("file>", "string>");
        proxyXML = proxyXML.replaceAll("integer>", "string>");
        proxyXML = proxyXML.replaceAll("float>", "string>");
        proxyXML = proxyXML.replaceAll("double>", "string>");
        proxyXML = proxyXML.replaceFirst("</title>", " - GWE Powered</title>");
        proxyXML = proxyXML.replaceFirst("</description>", "\n\nPowered by GWE</description>");
        return proxyXML;
    }

    public String runProxyApp(String[] args) throws P2ELSyntaxException {
        this.template.loadArgs(args);
        String clusterSel = this.template.getArg(this.optClusterDesc);
        HeadResourceInfo daemonInfo = this.appConfig.getGrid().getHeadResource(clusterSel);
        this.appConfig.setClusterSelected(daemonInfo);
        String moduleInvocation = this.proxiedModule.getModuleInvocation(this.getRemoteSlicerLocation());
        String moduleArgs = StringUtils.getArrayAsStr(this.template.getWithoutOptionsArgs(args));
        P2ELStatement stmt = this.appConfig.createStatement(this.getIterVariables() + " " + moduleInvocation + " " + moduleArgs);
        try {
            this.queueOrder(stmt, null);
        }
        catch (Exception e) {
            this.outputErrorMessage(this.getExceptionMessage(e));
            log.error(e);
            System.exit(1);
        }
        return "";
    }

    public void queueOrder(P2ELStatement stmt, String email) throws ServerAPIConnectionException, PasswordMismatchException, GridNotSpecifiedException, GridNotFoundException, RemoteException, P2ELSyntaxException {
        GWECLMProxyAppEventListener listener = this.monitorDaemonEvents();
        OrderInfo order = new OrderInfo(new VelocityJobsDescriptor(stmt), email);
        order.setResultParserClass(SlicerResultParser.class);
        try {
            int orderId = this.appConfig.createLoggedInSession(this.getGWEUser()).queueOrder(order);
            if (listener != null) {
                listener.reportProgressFor(orderId, stmt.getCommandsCount());
            }
        }
        catch (OrderNotSpecifiedException e) {
        }
        catch (GWEDomainException e) {
            // empty catch block
        }
    }

    private String getExceptionMessage(Exception e) {
        if (e instanceof ServerAPIConnectionException) {
            return "Unable to connect to the GWE daemon";
        }
        if (e instanceof PasswordMismatchException) {
            return "GWE password mismatch error";
        }
        if (e instanceof GridNotSpecifiedException) {
            return "No grid selected/defined";
        }
        if (e instanceof GridNotFoundException) {
            return "Grid selected not found";
        }
        if (e instanceof P2ELSyntaxException) {
            return "P2EL syntax error";
        }
        if (e instanceof RemoteException) {
            return "Daemon reported error '" + e.getMessage() + "'";
        }
        return "Error: " + e.getMessage();
    }

    private GWECLMProxyAppEventListener monitorDaemonEvents() {
        try {
            GWECLMProxyAppEventListener evListener = new GWECLMProxyAppEventListener();
            this.appConfig.createAPIAccessor().createEventMonitor().monitorEvents(evListener, new DefaultEventFilter(null));
            return evListener;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void outputErrorMessage(String msg) {
        msg = "<filter-start>" + ERROR_FILTER_NAME + "<filter-comment>" + msg + "</filter-comment></filter-start>";
        msg = msg + "<filter-end>" + ERROR_FILTER_NAME + "<filter-time>0</filter-time></filter-end>";
        System.out.println(msg);
    }
}

