/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.integration.slicer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gwe.api.EventListener;
import org.gwe.api.event.Event;
import org.gwe.persistence.model.ModelSummary;

public class GWECLMProxyAppEventListener
extends EventListener {
    private static final int NUM_PROGRESS_EVENTS = 4;
    private static final int PROGRESS_BAR_LENGTH = 50;
    private static final float PROGRESS_BAR_PERCENTAGE_UNIT = 2.0f;
    private static final String FILTER_NAME = "GWECLMProxyApp";
    private int oId;
    private float stepPercentageIncrement;
    private Map<Integer, Integer> progress = new HashMap<Integer, Integer>();
    private boolean liveReporting = false;
    private long stepStartTime = System.currentTimeMillis();
    private boolean started = false;

    public void reportProgressFor(int orderId, int numJobs) {
        if (this.liveReporting) {
            throw new RuntimeException("Cannot change order to monitor!!!");
        }
        this.oId = orderId;
        this.stepPercentageIncrement = (float)(100.0 / (double)(numJobs * 4));
        this.logStep(orderId);
        this.liveReporting = true;
    }

    public void eventPerformed(Event ev) {
        List<ModelSummary> modelIds = ev.getModelIdentifiers();
        switch (ev.getEventType()) {
            case JOB_PREPARED: 
            case JOB_DISPATCHED: 
            case JOB_PROCESSED: 
            case JOB_COMPLETED: {
                this.logStep(modelIds.get(1).getKey());
                break;
            }
            case ORDER_COMPLETED: {
                if (!this.logStep(modelIds.get(0).getKey())) break;
                System.exit(0);
            }
        }
    }

    private boolean logStep(Object orderIdAsObj) {
        int pPercent;
        int orderId = Integer.parseInt(orderIdAsObj.toString());
        int pSteps = this.getProgressSteps(orderId);
        this.progress.put(orderId, this.progress.get(orderId) + 1);
        if (this.oId != orderId) {
            return false;
        }
        if (this.started) {
            System.out.println(" <filter-end>" + this.createFilterName(pSteps) + "<filter-time>" + (System.currentTimeMillis() - this.stepStartTime) + "</filter-time></filter-end>");
        }
        this.stepStartTime = System.currentTimeMillis();
        if ((pPercent = (int)((float)(++pSteps) * this.stepPercentageIncrement)) >= 100) {
            System.exit(0);
        }
        System.out.print("<filter-start>" + this.createFilterName(pSteps) + this.createFilterComment(pPercent) + "</filter-start>");
        this.started = true;
        return true;
    }

    private int getProgressSteps(int orderId) {
        Integer prog = this.progress.get(orderId);
        if (prog == null) {
            prog = 0;
            this.progress.put(orderId, prog);
        }
        return prog;
    }

    private String createFilterName(int pSteps) {
        return "<filter-name>GWECLMProxyApp" + pSteps + "</filter-name>";
    }

    private String createFilterComment(int pPercent) {
        int count;
        String result = "<filter-comment>";
        int barUnitsCompleted = (int)((float)pPercent / 2.0f);
        int barUnitsIncompleted = 50 - barUnitsCompleted;
        for (count = 0; count < barUnitsCompleted; ++count) {
            result = result + ">";
        }
        result = result + " GWE Background Service ";
        for (count = 0; count < barUnitsIncompleted; ++count) {
            result = result + ">";
        }
        return result + "</filter-comment>";
    }
}

