/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.integration.slicer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import org.gwe.integration.slicer.AbstractCLMProxyApp;
import org.gwe.utils.StringUtils;

public class WrapperCLMProxyApp
extends AbstractCLMProxyApp {
    protected String proxiedModuleName;

    public WrapperCLMProxyApp(String proxiedModuleName) {
        this.proxiedModuleName = proxiedModuleName;
    }

    public String getProxiedModuleName() {
        return this.proxiedModuleName;
    }

    public String getProxiedModuleInvocation() {
        return this.getModuleInvocation(this.slicerHome);
    }

    public String getModuleInvocation(String slicerHomeDir) {
        return slicerHomeDir + "/Slicer3 --launch " + this.getPluginsDir(slicerHomeDir) + "/" + this.proxiedModuleName;
    }

    protected String generateCLMErrorXML(IOException e) {
        return "";
    }

    public String generateProxyXML() {
        return this.executeOSCommand(this.getProxiedModuleInvocation() + " --xml");
    }

    public String runProxyApp(String[] args) throws Exception {
        return this.executeOSCommand(this.createOSCommand(args));
    }

    public String createOSCommand(String[] args) {
        return this.getProxiedModuleInvocation() + " " + StringUtils.getArrayAsStr(args);
    }

    private String executeOSCommand(String cmd) {
        try {
            BufferedReader rdr = new BufferedReader(new InputStreamReader(this.executeOSCommandInternal(cmd)));
            StringBuffer stdOut = new StringBuffer();
            char[] cbuf = new char[1024];
            int read = 0;
            while (read > -1) {
                stdOut.append(new String(cbuf).substring(0, read));
                read = rdr.read(cbuf);
            }
            return stdOut.toString();
        }
        catch (IOException e) {
            return this.generateCLMErrorXML(e);
        }
    }

    private InputStream executeOSCommandInternal2(String cmd) {
        try {
            return Runtime.getRuntime().exec(cmd).getInputStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    private InputStream executeOSCommandInternal(String cmd) {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(cmd.split(" "));
            Map<String, String> env = processBuilder.environment();
            Process proc = processBuilder.start();
            return proc.getInputStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static void main(String[] args) {
        String cmd = "/Users/admin/Slicer3-3.0.2008-02-14-darwin-x86/Slicer3 --launch /Users/admin/Slicer3-3.0.2008-02-14-darwin-x86/lib/Slicer3/Plugins/dwiNoiseFilter /tmp/Slicer3admin/EAFB_vtkMRMLScalarVolumeNodeB.nrrd /tmp/Slicer3admin/EAFB_vtkMRMLScalarVolumeNodeC.nrrd --iter 1 --re 3,3,0 --rf 3,3,0 --mnvf 1 --mnve 1 --minnstd 0 --maxnstd 10000 --hrf 2 --uav";
        new WrapperCLMProxyApp(cmd).executeOSCommand(cmd);
    }
}

