/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.integration.slicer.chains;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwe.integration.slicer.AbstractCLMProxyApp;
import org.gwe.integration.slicer.WrapperCLMProxyApp;
import org.gwe.integration.slicer.chains.ChainCLMDesc;
import org.gwe.integration.slicer.chains.ChainDesc;
import org.gwe.integration.slicer.model.ExecutableModel;
import org.gwe.integration.slicer.model.ExecutableModelParser;
import org.gwe.integration.slicer.model.GroupModel;
import org.gwe.integration.slicer.model.ParameterModel;
import org.gwe.utils.cmd.OptionTemplate;
import org.gwe.utils.cmd.OptionableAppTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainCLMProxyApp
extends AbstractCLMProxyApp {
    private static Log log = LogFactory.getLog(ChainCLMProxyApp.class);
    private static String ARG_PREFIX = "clm_";
    private static String TITLE_SEPARATOR = " | ";
    private List<AbstractCLMProxyApp> clmApps = new ArrayList<AbstractCLMProxyApp>();
    private ChainDesc chain;

    public static void main(String[] args) throws Exception {
        ChainCLMProxyApp.mainIdBased(ChainCLMProxyApp.class, args);
    }

    public ChainCLMProxyApp(String chainDescriptorFile) throws Exception {
        this.chain = new ChainDesc(chainDescriptorFile);
        ExecutableModelParser descParser = new ExecutableModelParser();
        for (ChainCLMDesc clmDesc : this.chain.getCLMs()) {
            WrapperCLMProxyApp proxyApp = new WrapperCLMProxyApp(clmDesc.getId());
            proxyApp.setXmlModel(descParser.readExecutableModel(proxyApp.generateProxyXML()));
            this.clmApps.add(proxyApp);
        }
    }

    @Override
    public String generateProxyXML() throws Exception {
        ExecutableModel result = new ExecutableModel(this.createTitle(), "Composite Chains", "", "org/gwe/integration/slicer/chains/chainsSEMTemplate.vm");
        for (int idx = 0; idx < this.clmApps.size(); ++idx) {
            ExecutableModel currAppModel = this.clmApps.get(idx).getXmlModel();
            ChainCLMDesc currChainDesc = this.chain.getCLMs().get(idx);
            String groupTitlePrefix = currAppModel.getTitle() + " - ";
            for (GroupModel groupModel : currAppModel.getGroups()) {
                String newLabel = groupTitlePrefix + groupModel.getLabel();
                GroupModel currGroup = result.addGroup(newLabel, groupModel.getDescription());
                for (ParameterModel paramModel : groupModel.getParameters()) {
                    if (currChainDesc.getPipedArguments().containsKey(paramModel.getName())) continue;
                    currGroup.addParam(this.createProxiedParam(currChainDesc.getId(), paramModel));
                }
            }
        }
        return result.getXML();
    }

    private ParameterModel createProxiedParam(String chainLinkId, ParameterModel param) {
        String flagsPrefix = this.createFlagPrefix(chainLinkId);
        String valueType = param.getValueType();
        String label = param.getLabel();
        String longFlag = flagsPrefix + param.getLongFlag();
        String description = param.getDescription();
        String defaultValue = param.getDefaultValue();
        ParameterModel result = new ParameterModel(valueType, label, longFlag, description, defaultValue);
        result.setName(longFlag);
        result.setFlag(flagsPrefix + param.getFlag());
        result.setFiller(param.getFiller(false, true));
        return result;
    }

    private String createFlagPrefix(String chainLinkId) {
        return this.appendArgPrefix(chainLinkId + "_");
    }

    private String appendArgPrefix(String flagId) {
        return ARG_PREFIX + flagId;
    }

    private String createTitle() {
        String title = "";
        for (AbstractCLMProxyApp proxyApp : this.clmApps) {
            title = title + proxyApp.getXmlModel().getTitle() + TITLE_SEPARATOR;
        }
        return title.substring(0, title.length() - TITLE_SEPARATOR.length());
    }

    @Override
    public String runProxyApp(String[] args) throws Exception {
        String slicerCommandInvocations = "#!/bin/sh\n# Autogenerated chain script\n";
        for (int appIndex = 0; appIndex < this.clmApps.size(); ++appIndex) {
            ChainCLMDesc currChainDesc = this.chain.getCLMs().get(appIndex);
            List<String> argsList = this.constructCLMArgs(args, currChainDesc);
            Map<String, String> pipedArgsValues = this.readPipedArgsValues(args, currChainDesc.getPipedArguments());
            for (Map.Entry<String, String> clmArg : pipedArgsValues.entrySet()) {
                argsList.add("--" + clmArg.getKey());
                argsList.add(clmArg.getValue());
            }
            WrapperCLMProxyApp wrapperApp = (WrapperCLMProxyApp)this.clmApps.get(appIndex);
            String[] chainedModuleArgs = this.fixIndexedArgs(argsList, appIndex).toArray(new String[0]);
            slicerCommandInvocations = slicerCommandInvocations + wrapperApp.createOSCommand(chainedModuleArgs) + "\n";
        }
        this.writeScript(slicerCommandInvocations);
        return "";
    }

    private void writeScript(String content) {
        try {
            FileOutputStream fos = new FileOutputStream(this.slicerHome + "/chains/chain.sh", false);
            fos.write(content.getBytes());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private List<String> constructCLMArgs(String[] args, ChainCLMDesc currChainDesc) {
        ArrayList<String> result = new ArrayList<String>();
        String flagsPrefix = this.createFlagPrefix(currChainDesc.getId());
        for (int argIndex = 0; argIndex < args.length; ++argIndex) {
            String newValue = args[argIndex].replace(flagsPrefix, "");
            if (!newValue.startsWith("--" + ARG_PREFIX)) {
                result.add(newValue);
                continue;
            }
            if (args[argIndex + 1].startsWith("--")) continue;
            ++argIndex;
        }
        return result;
    }

    private Map<String, String> readPipedArgsValues(String[] args, Map<String, String> pipedArgsMappings) {
        OptionableAppTemplate invocationTemplate = new OptionableAppTemplate();
        HashMap<String, OptionTemplate> chainedOptions = new HashMap<String, OptionTemplate>();
        for (String clmArg : pipedArgsMappings.keySet()) {
            OptionTemplate option = new OptionTemplate(this.appendArgPrefix(pipedArgsMappings.get(clmArg)), "");
            chainedOptions.put(clmArg, option);
            invocationTemplate.addOption(option, null);
        }
        invocationTemplate.loadArgs(args);
        HashMap<String, String> pipedArgsValues = new HashMap<String, String>();
        for (Map.Entry clmArg : chainedOptions.entrySet()) {
            pipedArgsValues.put((String)clmArg.getKey(), invocationTemplate.getArg((OptionTemplate)clmArg.getValue()));
        }
        return pipedArgsValues;
    }

    private List<String> fixIndexedArgs(List<String> argsList, int appIndex) {
        HashMap<String, Integer> indexedArgs = new HashMap<String, Integer>();
        for (ParameterModel param : this.clmApps.get(appIndex).getXmlModel().getParameters()) {
            if (param.getIndex() == -1) continue;
            indexedArgs.put(param.getLongFlag(), param.getIndex());
        }
        TreeMap indexedInvocations = new TreeMap();
        ArrayList<String> result = new ArrayList<String>();
        for (int argIndex = 0; argIndex < argsList.size(); ++argIndex) {
            String nextArg;
            String argInvoc = argsList.get(argIndex);
            String arg = argInvoc.replace("-", "");
            if (!indexedArgs.containsKey(arg)) {
                result.add(argInvoc);
                continue;
            }
            String string = nextArg = argsList.size() > argIndex + 1 ? argsList.get(argIndex + 1) : "";
            if (nextArg == null) {
                nextArg = "";
            }
            boolean isValueNextArg = !nextArg.startsWith("--");
            indexedInvocations.put(indexedArgs.get(arg), isValueNextArg ? nextArg : "");
            if (!isValueNextArg) continue;
            ++argIndex;
        }
        int count = 0;
        for (Map.Entry entry : indexedInvocations.entrySet()) {
            result.add(count, (String)entry.getValue());
            ++count;
        }
        return result;
    }
}

