/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.integration.slicer.chains;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.gwe.integration.slicer.chains.ChainCLMDesc;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainDesc {
    private List<ChainCLMDesc> modules = new ArrayList<ChainCLMDesc>();

    public ChainDesc(String chainDescriptorFile) throws SAXException, IOException, ParserConfigurationException {
        Document dom = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(chainDescriptorFile);
        NodeList nl = dom.getDocumentElement().getElementsByTagName("module");
        if (nl != null) {
            for (int index = 0; index < nl.getLength(); ++index) {
                this.modules.add(this.readModule((Element)nl.item(index)));
            }
        }
    }

    private ChainCLMDesc readModule(Element moduleEle) {
        String id = moduleEle.getAttribute("id");
        HashMap<String, String> pipedArgs = new HashMap<String, String>();
        NodeList nl = moduleEle.getElementsByTagName("argument");
        if (nl != null) {
            for (int index = 0; index < nl.getLength(); ++index) {
                Element el = (Element)nl.item(index);
                pipedArgs.put(el.getAttribute("name"), el.getAttribute("value-ref").replace('.', '_'));
            }
        }
        return new ChainCLMDesc(id, pipedArgs);
    }

    public List<ChainCLMDesc> getCLMs() {
        return this.modules;
    }

    public String toString() {
        return this.modules.toString();
    }

    public static void main(String[] args) throws SAXException, IOException, ParserConfigurationException {
        System.out.println(new ChainDesc("/Users/admin/work/eclipse-ws/gwe-core/tmp/chain.xml"));
    }
}

