/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.integration.slicer.model;

import java.util.ArrayList;
import java.util.List;
import org.gwe.integration.slicer.model.GroupModel;
import org.gwe.integration.slicer.model.ParameterModel;
import org.gwe.utils.IOUtils;
import org.gwe.utils.VelocityUtils;
import org.gwe.utils.cmd.OptionTemplate;
import org.gwe.utils.cmd.OptionableAppTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutableModel
extends OptionableAppTemplate {
    public final OptionTemplate OPT_XML = new OptionTemplate("xml", "XML. Displays the CLM schema.");
    public final OptionTemplate OPT_LOGO = new OptionTemplate("logo", "Logo. Returns a stream with a custom logo image for this CLM.");
    private String category;
    private String title;
    private String description;
    private String version = "1.0-Alpha";
    private String url = "";
    private String license = "http://www.apache.org/licenses/LICENSE-2.0.txt";
    private String contributor = "Jeff Grethe, Marco Ruiz";
    private String acknowledgements = "BIRN CC - 'Grid Wizard Enterprise' (GWE) Project";
    private List<GroupModel> groups = new ArrayList<GroupModel>();
    private String xmlTemplate;

    public static String getXMLHeader() {
        return "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n";
    }

    public ExecutableModel(String title, String category, String description) {
        this(title, category, description, "standardExecutionModel.vm");
    }

    public ExecutableModel(String title, String category, String description, String templateFilename) {
        this.category = category;
        this.title = title;
        this.description = description;
        this.setXMLTemplate(IOUtils.readClassPathFile(templateFilename));
    }

    public void setXMLTemplate(String xmlTemplate) {
        this.xmlTemplate = xmlTemplate;
    }

    @Override
    public void loadArgs(String[] args) {
        this.loadArgs(args, false);
    }

    public void loadArgs(String[] args, boolean processXML) {
        for (GroupModel group : this.groups) {
            for (ParameterModel param : group.getParameters()) {
                this.addArg(param);
            }
        }
        this.addArg(this.OPT_XML);
        this.addArg(this.OPT_LOGO);
        super.loadArgs(args);
        if (processXML) {
            this.outputXMLIfRequested();
        }
    }

    private void outputXMLIfRequested() {
        if (this.isXMLSelected()) {
            System.out.println(this.getXML());
            System.exit(0);
        }
    }

    public boolean isXMLSelected() {
        return this.getArg(this.OPT_XML) != null;
    }

    public boolean isLogoSelected() {
        return this.getArg(this.OPT_LOGO) != null;
    }

    public String getXML() {
        return ExecutableModel.getXMLHeader() + VelocityUtils.merge("executable", this, this.xmlTemplate);
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String documentationURL) {
        this.url = documentationURL;
    }

    public String getContributor() {
        return this.contributor;
    }

    public void setContributor(String contributor) {
        this.contributor = contributor;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public String getAcknowledgements() {
        return this.acknowledgements;
    }

    public void setAcknowledgements(String acknowledgements) {
        this.acknowledgements = acknowledgements;
    }

    public List<GroupModel> getGroups() {
        return this.groups;
    }

    public GroupModel addGroup(String label, String description) {
        GroupModel group = new GroupModel(label, description);
        this.groups.add(group);
        return group;
    }

    public List<ParameterModel> getParameters() {
        ArrayList<ParameterModel> result = new ArrayList<ParameterModel>();
        for (GroupModel group : this.groups) {
            result.addAll(group.getParameters());
        }
        return result;
    }
}

