/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.integration.slicer.model;

import java.io.ByteArrayInputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import org.gwe.integration.slicer.model.ExecutableModel;
import org.gwe.integration.slicer.model.GroupModel;
import org.gwe.integration.slicer.model.ParameterModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExecutableModelParser {
    public ExecutableModel readExecutableModel(String xml) throws Exception {
        ByteArrayInputStream xmlStream = new ByteArrayInputStream(xml.getBytes());
        Document dom = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(xmlStream);
        Element root = (Element)((Object)dom.getDocumentElement().getChildNodes());
        ExecutableModel result = new ExecutableModel(this.readVal(root, "title", new boolean[0]), this.readVal(root, "category", new boolean[0]), this.readVal(root, "description", new boolean[0]));
        result.setVersion(this.readVal(root, "version", new boolean[0]));
        result.setUrl(this.readVal(root, "documentation-url", new boolean[0]));
        result.setLicense(this.readVal(root, "license", new boolean[0]));
        result.setContributor(this.readVal(root, "contributor", new boolean[0]));
        result.setAcknowledgements(this.readVal(root, "acknowledgements", new boolean[0]));
        NodeList children = root.getElementsByTagName("parameters");
        if (children != null) {
            for (int idx = 0; idx < children.getLength(); ++idx) {
                Element groupEle = (Element)children.item(idx);
                String label = this.readVal(groupEle, "label", new boolean[0]);
                String description = this.readVal(groupEle, "description", new boolean[0]);
                this.readGroup(groupEle, result.addGroup(label, description));
            }
        }
        return result;
    }

    private void readGroup(Element groupEle, GroupModel groupModel) {
        NodeList children = groupEle.getChildNodes();
        if (children != null) {
            for (int idx = 0; idx < children.getLength(); ++idx) {
                Element paramEle;
                String valueType;
                Node child = children.item(idx);
                if (child.getNodeType() != 1 || (valueType = (paramEle = (Element)child).getTagName()).equals("label") || valueType.equals("description")) continue;
                groupModel.addParam(this.readParameter(paramEle));
            }
        }
    }

    private ParameterModel readParameter(Element paramEle) {
        String valueType = paramEle.getTagName();
        String name = this.extractVal(paramEle, "name");
        String label = this.extractVal(paramEle, "label");
        String flag = this.extractVal(paramEle, "flag");
        String longFlag = this.extractVal(paramEle, "longflag");
        String description = this.extractVal(paramEle, "description");
        String defaultValue = this.extractVal(paramEle, "default");
        String index = this.extractVal(paramEle, "index");
        String channel = this.extractVal(paramEle, "channel");
        ParameterModel result = new ParameterModel(valueType, label, longFlag, description, defaultValue);
        result.setName(name);
        result.setFlag(flag);
        if (index != null) {
            result.setIndex(Integer.parseInt(index));
        }
        result.setChannel(channel);
        result.setFiller(this.generateChildrenXMLFragment(paramEle));
        return result;
    }

    private String extractVal(Element ele, String tagName) {
        return this.readVal(ele, tagName, true);
    }

    private String readVal(Element ele, String tagName, boolean ... extract) {
        Element el;
        Node firstChild;
        String result = null;
        NodeList nl = ele.getElementsByTagName(tagName);
        if (nl != null && nl.getLength() > 0 && (firstChild = (el = (Element)nl.item(0)).getFirstChild()) != null) {
            result = firstChild.getNodeValue();
            if (extract.length > 0 && extract[0]) {
                ele.removeChild(el);
            }
        }
        return result;
    }

    public String generateXMLFragment(Element node) {
        String nodeName = node.getNodeName();
        String nodeValue = ExecutableModelParser.getElementValue(node);
        NamedNodeMap attributes = node.getAttributes();
        String result = "<" + nodeName;
        for (int index = 0; index < attributes.getLength(); ++index) {
            Node attr = attributes.item(index);
            result = result + " " + attr.getNodeName() + "=\"" + attr.getNodeValue() + "\" ";
        }
        return result + ">" + nodeValue + this.generateChildrenXMLFragment(node) + "</" + nodeName + ">";
    }

    private String generateChildrenXMLFragment(Element node) {
        String result = "";
        NodeList children = node.getChildNodes();
        for (int index = 0; index < children.getLength(); ++index) {
            Node child = children.item(index);
            if (child.getNodeType() != 1) continue;
            result = result + this.generateXMLFragment((Element)child);
        }
        return result;
    }

    public static final String getElementValue(Node elem) {
        if (elem != null && elem.hasChildNodes()) {
            for (Node kid = elem.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
                if (kid.getNodeType() != 3) continue;
                return kid.getNodeValue();
            }
        }
        return "";
    }
}

