/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.integration.slicer.model;

import org.gwe.utils.cmd.OptionTemplate;

public class ParameterModel
extends OptionTemplate {
    private String valueType;
    private String name = "";
    private String longFlag = null;
    private String label = "";
    private int index = -1;
    private String channel = null;
    private String filler = "";

    public ParameterModel(String valueType, String label, String longFlag, String description, String defaultValue) {
        super(longFlag, description, defaultValue);
        this.valueType = valueType;
        this.label = label;
        this.setLongFlag(longFlag);
    }

    public String getValueType() {
        return this.valueType;
    }

    public void setValueType(String tag) {
        this.valueType = tag;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        if (this.longFlag == null || this.longFlag.equals("")) {
            this.setLongFlag(name);
        }
    }

    public String getLongFlag() {
        return this.longFlag;
    }

    public void setLongFlag(String longFlag) {
        while (longFlag != null && longFlag.startsWith("-")) {
            longFlag = longFlag.substring(1);
        }
        this.longFlag = longFlag;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getFlag() {
        return "";
    }

    public void setFlag(String flag) {
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getFiller() {
        return this.getFiller(true, true);
    }

    public String getFiller(boolean includeIndexIfPresent, boolean includeChannelIfPresent) {
        String result;
        String string = result = includeIndexIfPresent && this.index != -1 ? "<index>" + this.index + "</index>\n" : "";
        if (includeChannelIfPresent && this.channel != null) {
            result = result + "<channel>" + this.channel + "</channel>\n";
        }
        return result + this.filler;
    }

    public void setFiller(String filler) {
        if (filler != null) {
            this.filler = filler;
        }
    }
}

