/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.integration.slicer.model.exec;

import org.gwe.integration.slicer.model.ExecutableModel;
import org.gwe.integration.slicer.model.GroupModel;
import org.gwe.integration.slicer.model.param.PMString;
import org.gwe.utils.cmd.OptionTemplate;
import org.gwe.utils.cmd.OptionableAppTemplate;

public class ExecBaseGWEModel
extends ExecutableModel {
    protected OptionTemplate clmOptionSlicer;
    protected OptionTemplate clmOptionVariables;
    protected PMString clmOptionCluster;
    protected PMString clmOptionPort;
    protected PMString clmOptionAccount;
    protected PMString clmOptionPassword;
    protected PMString clmOptionInDir;
    protected PMString clmOptionOutDir;
    protected GroupModel gridGroupModel = this.addGroup("GWE Settings", "Slicer3 Grid Settings");
    protected GroupModel inputGroupModel = this.addGroup("Input File Settings", "Determine where the input files are located.");
    protected GroupModel outputGroupModel = this.addGroup("Output File Settings", "Determines where the output files will be written");
    protected GroupModel algorithmGroupModel = this.addGroup("Algorithm Parameters", "Parameters that determine how the algorithm runs");

    public ExecBaseGWEModel(String title, String category, String description) {
        super(title, category, description);
        this.clmOptionCluster = this.gridGroupModel.addParam(new PMString("Cluster Head Node", "gweHost", "Address of the cluster head node where to reach GWE daemon", "cluster.bwh.harvard.edu"));
        this.clmOptionPort = this.gridGroupModel.addParam(new PMString("Cluster Head Node Port", "gweHost", "Address of the cluster head node where to reach GWE daemon", "1099"));
        this.clmOptionAccount = this.gridGroupModel.addParam(new PMString("Account", "gweUser", "Account to ssh into cluster head node"));
        this.clmOptionPassword = this.gridGroupModel.addParam(new PMString("Password", "gwePassword", "Password of the account"));
        this.clmOptionSlicer = this.gridGroupModel.addParam(new PMString("Slicer Location", "slicerLocation", "Location of Slicer Build directory on the cluster"));
        this.clmOptionVariables = this.gridGroupModel.addParam(new PMString("Iteration Variables", "iterationVariables", "Variables to iterate to generate the commands to run in the cluster"));
    }

    public OptionableAppTemplate clone() {
        OptionableAppTemplate result = super.clone();
        result.removeOption(this.clmOptionSlicer);
        return result;
    }
}

