/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.p2el;

import java.util.ArrayList;
import java.util.List;
import org.gwe.p2el.P2ELExpressionContext;
import org.gwe.p2el.P2ELFunction;
import org.gwe.p2el.P2ELFunctionInvocation;
import org.gwe.p2el.P2ELFunctionInvocationPhase;
import org.gwe.p2el.P2ELSyntaxException;
import org.gwe.p2el.P2ELVariable;
import org.gwe.utils.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P2ELExpression {
    private String expression;
    private P2ELExpressionContext context;
    private String exprSufix;
    private List<P2ELFunctionInvocation> invocations = new ArrayList<P2ELFunctionInvocation>();

    P2ELExpression(P2ELExpressionContext ctx, String expr, List<P2ELFunction> functions) throws P2ELSyntaxException {
        String[] pieces;
        this.expression = expr;
        this.context = ctx;
        String prefix = "";
        String remainder = expr;
        while ((pieces = StringUtils.splitBoundaries(remainder, "f:", "(")) != null) {
            String functionName = pieces[2];
            P2ELFunction function = this.getFunction(functionName, functions);
            if (function == null) {
                prefix = prefix + pieces[0] + pieces[1];
                remainder = pieces[2] + pieces[3] + pieces[4];
                continue;
            }
            String[] invocationPieces = StringUtils.splitBoundaries(remainder, "f:" + functionName + "(", ")", "(");
            if (invocationPieces == null) {
                throw new P2ELSyntaxException("Function invocation missing closing parenthesis");
            }
            P2ELExpression paramsExpr = new P2ELExpression(ctx, invocationPieces[2], functions);
            this.invocations.add(function.createInvocation(prefix + invocationPieces[0], paramsExpr));
            prefix = "";
            remainder = invocationPieces[4];
        }
        this.exprSufix = prefix + remainder;
    }

    public P2ELExpressionContext getContext() {
        return this.context;
    }

    private P2ELFunction getFunction(String id, List<P2ELFunction> functions) {
        for (P2ELFunction function : functions) {
            if (!function.getId().equals(id)) continue;
            return function;
        }
        return null;
    }

    public String runPrecompilationPhase(P2ELFunctionInvocationPhase phase, List<P2ELVariable> exprVars) throws P2ELSyntaxException {
        return this.runCommandPhase(phase, exprVars);
    }

    public String compile() throws P2ELSyntaxException {
        return this.runCommandPhase(P2ELFunctionInvocationPhase.COMPILE, new Object[0]);
    }

    private String runCommandPhase(P2ELFunctionInvocationPhase phase, Object ... phaseArgs) throws P2ELSyntaxException {
        try {
            for (P2ELFunctionInvocation invoc : this.invocations) {
                switch (phase) {
                    case INTERPRET: 
                    case EXPAND: 
                    case PREEVALUATE: {
                        invoc.runPrecompilationPhase(phase, this.context, (List)phaseArgs[0]);
                        break;
                    }
                    case COMPILE: {
                        invoc.compile(this.context);
                    }
                }
            }
            return this.toString();
        }
        catch (P2ELSyntaxException e) {
            throw e;
        }
        catch (Exception e) {
            throw new P2ELSyntaxException("An error was encountered while trying to " + phase.getName() + " the P2EL statement " + this.expression, e);
        }
    }

    public List<Object> getCompilationModels() {
        return this.getCompilationModels(null);
    }

    public List<Object> getCompilationModels(Class<? extends P2ELFunction> functionClass) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (P2ELFunctionInvocation invoc : this.invocations) {
            Object compModel;
            if (functionClass != null && !functionClass.isAssignableFrom(invoc.getFunctionClass()) || (compModel = invoc.getCompilationModel()) == null) continue;
            result.add(compModel);
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        for (P2ELFunctionInvocation invoc : this.invocations) {
            result.append(invoc.toString());
        }
        return result.append(this.exprSufix).toString();
    }
}

