/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.p2el;

import java.util.List;
import org.gwe.p2el.P2ELCompilationResult;
import org.gwe.p2el.P2ELExpression;
import org.gwe.p2el.P2ELExpressionContext;
import org.gwe.p2el.P2ELFunction;
import org.gwe.p2el.P2ELFunctionInvocationPhase;
import org.gwe.p2el.P2ELSyntaxException;
import org.gwe.p2el.P2ELVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class P2ELFunctionInvocation<COMPILATION_MODEL_TYPE> {
    public static final String FUNCTION_PREFIX = "f:";
    private String invocationPrefix;
    private P2ELFunction<COMPILATION_MODEL_TYPE> function;
    protected P2ELExpression params;
    protected String evalValue = null;
    private P2ELCompilationResult<COMPILATION_MODEL_TYPE> compilationResult;

    protected P2ELFunctionInvocation(String invocationPrefix, P2ELFunction<COMPILATION_MODEL_TYPE> function, P2ELExpression params) throws P2ELSyntaxException {
        this.invocationPrefix = invocationPrefix;
        this.function = function;
        this.params = params;
    }

    public String getInvocationPrefix() {
        return this.invocationPrefix;
    }

    public P2ELFunction<COMPILATION_MODEL_TYPE> getFunction() {
        return this.function;
    }

    protected void setEvalValue(String evalValue) {
        this.evalValue = evalValue;
    }

    public void runPrecompilationPhase(P2ELFunctionInvocationPhase phase, P2ELExpressionContext ctx, List<P2ELVariable> variables) throws P2ELSyntaxException {
        this.params.runPrecompilationPhase(phase, variables);
        this.evalValue = this.function.runPrecompilationPhase(phase, ctx, this.params.toString(), variables);
    }

    public void compile(P2ELExpressionContext ctx) throws Exception {
        this.params.compile();
        this.compilationResult = this.function.compile(ctx, this.params.toString());
        this.evalValue = this.compilationResult.getReplacement();
    }

    public COMPILATION_MODEL_TYPE getCompilationModel() {
        return this.compilationResult != null ? (COMPILATION_MODEL_TYPE)this.compilationResult.getCompilationModel() : null;
    }

    public Class<? extends P2ELFunction> getFunctionClass() {
        return this.function.getClass();
    }

    public String toString() {
        String invocation = this.evalValue != null ? this.evalValue : FUNCTION_PREFIX + this.function.getId() + "(" + this.params + ")";
        return this.invocationPrefix + invocation;
    }
}

