/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.p2el;

import org.gwe.p2el.P2ELRangeNumber;
import org.gwe.p2el.P2ELSyntaxException;
import org.gwe.p2el.P2LRangeChar;
import org.gwe.p2el.P2LRangeSingleValue;

public abstract class P2ELRange {
    protected float step;

    public static P2ELRange createRange(String declaration) throws P2ELSyntaxException {
        String[] parts = declaration.split("\\|\\|");
        String[] range = parts[0].split("\\.\\.");
        String startValue = range[0];
        if (parts.length == 1 && range.length == 1) {
            return new P2LRangeSingleValue(startValue);
        }
        String endValue = range[1];
        Float stepValue = new Float(1.0f);
        String valueFormat = "x";
        try {
            stepValue = Float.valueOf(parts[1]);
            valueFormat = parts[1];
        }
        catch (Exception e) {
            // empty catch block
        }
        if (startValue.length() == 1 && endValue.length() == 1) {
            char startChar = startValue.charAt(0);
            char endChar = endValue.charAt(0);
            if (Character.isLetter(startChar) && Character.isLetter(endChar)) {
                return new P2LRangeChar(startValue.charAt(0), endValue.charAt(0), stepValue.intValue());
            }
        }
        try {
            return new P2ELRangeNumber(Float.parseFloat(startValue), Float.parseFloat(endValue), stepValue.floatValue(), valueFormat);
        }
        catch (NumberFormatException e) {
            throw new P2ELSyntaxException("Missing expected float values.");
        }
    }

    protected P2ELRange(float step) {
        this.step = step;
    }

    public abstract String getRange();
}

