/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.p2el;

import org.gwe.p2el.P2ELRange;

class P2ELRangeNumber
extends P2ELRange {
    private float start;
    private float end;
    private NumberFormatter formatter;

    protected P2ELRangeNumber(float start, float end, float step, String format) {
        super(step);
        this.start = start;
        this.end = end;
        this.formatter = new NumberFormatter(format);
    }

    public String getRange() {
        StringBuffer result = new StringBuffer("'");
        try {
            result.append(this.formatter.getAsString(Float.valueOf(this.start)));
            for (float curr = this.start + this.step; curr <= this.end; curr += this.step) {
                result.append("','" + this.formatter.getAsString(Float.valueOf(curr)));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        result.append("'");
        return result.toString();
    }

    class NumberFormatter {
        private int minIntSize;
        private int decimalPlaces = 0;
        private int decimalPlacesConversionFactor = 0;

        NumberFormatter(String format) {
            int pointIdx = format.indexOf(46);
            this.minIntSize = format.length();
            if (pointIdx != -1) {
                this.minIntSize = pointIdx;
                this.decimalPlaces = format.length() - pointIdx - 1;
                this.decimalPlacesConversionFactor = (int)Math.pow(10.0, this.decimalPlaces);
            }
        }

        public String getAsString(Float number) {
            long intPart = (long)Math.abs(number.floatValue());
            String result = this.formattedInt(intPart, this.minIntSize);
            if (this.decimalPlaces > 0) {
                long decimals = (long)Math.abs(number.floatValue() * (float)this.decimalPlacesConversionFactor) - intPart * (long)this.decimalPlacesConversionFactor;
                result = result + "." + this.formattedInt(decimals, this.decimalPlaces);
            }
            return result;
        }

        private String formattedInt(long value, int minSize) {
            String result = String.valueOf(value);
            String leadingZeros = "";
            for (int idx = minSize - result.length(); idx > 0; --idx) {
                leadingZeros = leadingZeros + "0";
            }
            return leadingZeros + result;
        }
    }
}

