/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.p2el;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.gwe.GWEAppContext;
import org.gwe.app.client.ClusterNotSpecifiedException;
import org.gwe.app.client.XMLClientAppConfig;
import org.gwe.p2el.P2ELEngine;
import org.gwe.p2el.P2ELExpression;
import org.gwe.p2el.P2ELExpressionContext;
import org.gwe.p2el.P2ELFunction;
import org.gwe.p2el.P2ELFunctionInvocationPhase;
import org.gwe.p2el.P2ELSyntaxException;
import org.gwe.p2el.P2ELVariable;
import org.gwe.utils.VelocityUtils;
import org.gwe.utils.security.CredentialNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P2ELStatement {
    private List<P2ELVariable> variables = new ArrayList<P2ELVariable>();
    private String cmdTemplateStr;
    private P2ELExpression cmdExpression;
    private List<P2ELFunction> functions;

    P2ELStatement(P2ELExpressionContext context, String statement, List<P2ELFunction> functions) throws P2ELSyntaxException {
        String varDeclaration;
        int limitIdx;
        this.cmdTemplateStr = statement.trim();
        this.functions = functions;
        while ((limitIdx = this.cmdTemplateStr.indexOf(" ")) >= 0 && this.addVar(varDeclaration = this.cmdTemplateStr.substring(0, limitIdx)) != null) {
            this.cmdTemplateStr = this.cmdTemplateStr.substring(limitIdx).trim();
        }
        this.cmdExpression = new P2ELExpression(context, this.cmdTemplateStr, functions);
    }

    public P2ELVariable addVar(String varDefintion) throws P2ELSyntaxException {
        return this.addVar(P2ELVariable.createVariable(varDefintion));
    }

    public P2ELVariable addVar(P2ELVariable var) {
        if (var == null) {
            return null;
        }
        this.variables.add(var);
        return var;
    }

    public List<P2ELVariable> getVars() {
        return this.variables;
    }

    public String getVTLScript() {
        StringBuffer result = new StringBuffer("");
        for (P2ELVariable var : this.variables) {
            result.append("#foreach(" + var.getVTLDefinition() + ")\n");
        }
        result.append(this.cmdExpression.toString() + "\n");
        for (P2ELVariable var : this.variables) {
            result.append("#end\n");
        }
        return result.toString();
    }

    public String getEvaluatedVTLScript() {
        return VelocityUtils.evaluate(this.getVTLScript());
    }

    public String getStatement() {
        return this.getStatement(this.cmdExpression.toString());
    }

    public String getStatement(String expression) {
        StringBuffer result = new StringBuffer("");
        for (P2ELVariable var : this.variables) {
            result.append(var.getP2ELDefinition() + " ");
        }
        return result.append(expression).toString();
    }

    public int getCommandsCount() {
        try {
            P2ELStatement stmt = this.runPrecompilationPhase(P2ELFunctionInvocationPhase.INTERPRET).runPrecompilationPhase(P2ELFunctionInvocationPhase.EXPAND).runPrecompilationPhase(P2ELFunctionInvocationPhase.PREEVALUATE);
            return stmt.getEvaluatedVTLScript().split("\n").length;
        }
        catch (P2ELSyntaxException p2ELSyntaxException) {
            return -1;
        }
    }

    public P2ELStatement runPrecompilationPhase(P2ELFunctionInvocationPhase phase) throws P2ELSyntaxException {
        String exprStr = this.cmdExpression.runPrecompilationPhase(phase, this.variables);
        return new P2ELStatement(this.cmdExpression.getContext(), this.getStatement(exprStr), this.functions);
    }

    public static void main(String[] args) throws P2ELSyntaxException, FileNotFoundException, CredentialNotFoundException, ClusterNotSpecifiedException {
        XMLClientAppConfig appConfig = new XMLClientAppConfig(null, null);
        P2ELExpressionContext ctx = new P2ELExpressionContext(null, appConfig.getKeys());
        P2ELEngine engine = GWEAppContext.getP2ELEngine();
        String txt = "${HIST}=[0..100||025] ${WC}=[*] f:in(f:expand(sftp://birn-cluster0.nbirn.net/home/mruiz/Slicer3-3.0.2008-02-14-linux-x86/lib/Slicer3/Plugins/lib${WC}.so)) f:anon(['a','b'])-${WC} f:sys(ITER_ID)";
        P2ELStatement stmt = engine.createStatement(ctx, txt);
        P2ELStatement.outputStmt("INITIAL", stmt);
        stmt = stmt.runPrecompilationPhase(P2ELFunctionInvocationPhase.INTERPRET);
        P2ELStatement.outputStmt("INTERPRETED", stmt);
        stmt = stmt.runPrecompilationPhase(P2ELFunctionInvocationPhase.EXPAND);
        P2ELStatement.outputStmt("EXPANDED", stmt);
        stmt = stmt.runPrecompilationPhase(P2ELFunctionInvocationPhase.PREEVALUATE);
        P2ELStatement.outputStmt("PRE EVALUATED", stmt);
        System.out.println("EVALUATED\n" + stmt.getEvaluatedVTLScript() + "\n");
    }

    private static void outputStmt(String title, P2ELStatement stmt) {
        System.out.println(title + "\n" + stmt + "\n" + stmt.getVTLScript() + "\n");
    }
}

