/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.p2el;

import java.util.ArrayList;
import java.util.List;
import org.gwe.p2el.P2ELRange;
import org.gwe.p2el.P2ELSyntaxException;
import org.gwe.utils.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P2ELVariable {
    private String id;
    private List<P2ELRange> ranges = new ArrayList<P2ELRange>();

    public static P2ELVariable createVariable(String declaration) throws P2ELSyntaxException {
        String id = "";
        try {
            if (declaration.charAt(0) != '$') {
                return null;
            }
            int index = declaration.indexOf("=[");
            if (index == -1) {
                return null;
            }
            id = declaration.substring(1, index);
            if (id.startsWith("{")) {
                id = id.replace("{", "");
            }
            if (id.endsWith("}")) {
                id = id.replace("}", "");
            }
            int endRangesIndex = declaration.indexOf("]");
            String ranges = declaration.substring(index + 2, endRangesIndex);
            return new P2ELVariable(id, ranges);
        }
        catch (P2ELSyntaxException e) {
            throw e;
        }
        catch (Exception e) {
            throw new P2ELSyntaxException("Problem encountered trying to parse variable '" + id + "'", e);
        }
    }

    public static List<String> extractVarReferences(String expression) throws P2ELSyntaxException {
        String[] pieces;
        ArrayList<String> varReferences = new ArrayList<String>();
        while ((pieces = StringUtils.splitBoundaries(expression, "${", "}")) != null) {
            if (pieces[2].contains("${")) {
                throw new P2ELSyntaxException("Cannot reference a P2EL variable within another");
            }
            varReferences.add(pieces[1] + pieces[2] + pieces[3]);
            expression = pieces[4];
        }
        return varReferences;
    }

    public P2ELVariable(String id, String ranges) throws P2ELSyntaxException {
        this(id, ranges.split(","));
    }

    public P2ELVariable(String id, String[] ranges) throws P2ELSyntaxException {
        this.id = id;
        for (int idx = 0; idx < ranges.length; ++idx) {
            this.ranges.add(P2ELRange.createRange(ranges[idx]));
        }
    }

    public String getId() {
        return this.id;
    }

    public String getReference() {
        return "${" + this.id + "}";
    }

    public String getP2ELDefinition() {
        return this.getReference() + "=[" + this.getRangesString() + "]";
    }

    public String getVTLDefinition() {
        return this.getReference() + " in [" + this.getRangesString() + "]";
    }

    private String getRangesString() {
        String result = "";
        for (P2ELRange range : this.ranges) {
            if (result.length() != 0) {
                result = result + ",";
            }
            result = result + range.getRange();
        }
        return result;
    }

    public List<P2ELRange> getRanges() {
        return this.ranges;
    }

    public void setRanges(List<P2ELRange> ranges) {
        this.ranges = ranges;
    }

    public static void main(String[] args) {
        boolean result = false;
        result = "$var=[value,value]".matches("\\$.=\\[.\\]");
        result = "$=[]".matches("\\$.=\\[.\\]");
        result = "$=[]".matches("\\$.=\\[.\\]");
        result = "$=[]".matches("\\$.=\\[.\\]");
    }
}

