/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.p2el.functions;

import java.io.FileNotFoundException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gwe.GWEAppContext;
import org.gwe.app.client.ClusterNotSpecifiedException;
import org.gwe.app.client.XMLClientAppConfig;
import org.gwe.drivers.HandleOperationException;
import org.gwe.p2el.P2ELExpressionContext;
import org.gwe.p2el.P2ELFunction;
import org.gwe.p2el.P2ELFunctionInvocationPhase;
import org.gwe.p2el.P2ELRange;
import org.gwe.p2el.P2ELSyntaxException;
import org.gwe.p2el.P2ELVariable;
import org.gwe.utils.IOUtils;
import org.gwe.utils.security.CredentialNotFoundException;
import org.gwe.utils.security.KeyStore;
import org.gwe.utils.security.URILink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PFFileExpand
extends P2ELFunction<Object> {
    private static final String P2EL_AUTOGEN_WC_VAR_PREFIX = "P2EL_AUTOGEN_WC_VAR_";

    public PFFileExpand() {
        super("expand");
    }

    @Override
    public String runPrecompilationPhase(P2ELFunctionInvocationPhase phase, P2ELExpressionContext ctx, String params, List<P2ELVariable> vars) throws P2ELSyntaxException {
        String varRef;
        P2ELVariable varDeclaration;
        if (phase != P2ELFunctionInvocationPhase.EXPAND) {
            return null;
        }
        List<String> varReferences = P2ELVariable.extractVarReferences(params);
        if (varReferences.size() == 0 && params.contains("*")) {
            String wildcardAnonVarValue = params.substring(params.indexOf("*"), params.lastIndexOf("*") + 1);
            P2ELVariable wildcardAnonVar = new P2ELVariable(P2EL_AUTOGEN_WC_VAR_PREFIX + (vars.size() + 1), wildcardAnonVarValue);
            vars.add(wildcardAnonVar);
            params = params.replace(wildcardAnonVarValue, wildcardAnonVar.getReference());
            varReferences.add(wildcardAnonVar.getReference());
        }
        if (varReferences.size() == 1 && !params.contains("*") && (varDeclaration = this.getVarDeclaration(varRef = varReferences.get(0), vars)) != null && varDeclaration.getRanges().size() == 1) {
            String wcGlobExp = varDeclaration.getRanges().get(0).getRange();
            if ((wcGlobExp = wcGlobExp.substring(1, wcGlobExp.length() - 1)).contains("*")) {
                String globFilePath = params.replace(varRef, wcGlobExp);
                String regExpFilePath = params.replace(varRef, "(" + wcGlobExp.replace(".", "\\.").replace("**", "*").replace("*", ".*") + ")");
                List<String> wildcardMatches = this.resolveWildcardMatches(globFilePath, ctx.getKeys());
                varDeclaration.setRanges(this.createVarRanges(regExpFilePath, wildcardMatches));
            }
        }
        return params;
    }

    private P2ELVariable getVarDeclaration(String varReference, List<P2ELVariable> vars) {
        for (P2ELVariable var : vars) {
            if (!var.getReference().equals(varReference)) continue;
            return var;
        }
        return null;
    }

    private List<P2ELRange> createVarRanges(String regExpFilePath, List<String> matches) throws P2ELSyntaxException {
        regExpFilePath = PFFileExpand.extractFilePath(regExpFilePath);
        ArrayList<P2ELRange> ranges = new ArrayList<P2ELRange>();
        Pattern pattern = Pattern.compile(regExpFilePath);
        for (String match : matches) {
            Matcher matcher = pattern.matcher(match);
            if (!matcher.matches()) continue;
            ranges.add(P2ELRange.createRange(matcher.group(1)));
        }
        return ranges;
    }

    private static String extractFilePath(String fileURI) throws P2ELSyntaxException {
        try {
            URI uriObj = new URI(IOUtils.getFileBase(fileURI));
            int startIndex = fileURI.indexOf(uriObj.getPath());
            return fileURI.substring(startIndex);
        }
        catch (URISyntaxException e) {
            throw new P2ELSyntaxException("Syntax error found in wildcard file path '" + fileURI + "'");
        }
    }

    private List<String> resolveWildcardMatches(String globFilePath, KeyStore keys) throws P2ELSyntaxException {
        try {
            URILink link = keys != null ? keys.generateURILink(globFilePath) : URILink.createLocalLink(new URI(globFilePath));
            return GWEAppContext.getGridFileSystem().findWildcardMatches(link);
        }
        catch (URISyntaxException e) {
            throw new P2ELSyntaxException("", e);
        }
        catch (HandleOperationException e) {
            throw new P2ELSyntaxException("", e);
        }
    }

    public static void main(String[] args) throws P2ELSyntaxException, FileNotFoundException, CredentialNotFoundException, ClusterNotSpecifiedException {
        XMLClientAppConfig appConfig = new XMLClientAppConfig(null, null);
        PFFileExpand expander = new PFFileExpand();
        String p2elPath = "file:///Users/admin/.p*";
        ArrayList<P2ELVariable> vars = new ArrayList<P2ELVariable>();
        vars.add(new P2ELVariable("WILD", ".p*o*"));
        vars.add(new P2ELVariable("WILD2", "pr*"));
        P2ELExpressionContext ctx = new P2ELExpressionContext(null, appConfig.getKeys());
        System.out.println(expander.runPrecompilationPhase(P2ELFunctionInvocationPhase.EXPAND, ctx, p2elPath, vars));
        for (P2ELVariable var : vars) {
            System.out.println(var.getP2ELDefinition());
        }
    }
}

