/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.persistence.dao;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.List;
import org.gwe.persistence.model.BaseModelInfo;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericHibernateDaoSupport<INFO_TYPE extends BaseModelInfo<KEY_TYPE>, KEY_TYPE extends Serializable>
extends HibernateDaoSupport {
    private Class<INFO_TYPE> infoClass;
    private Class<KEY_TYPE> keyClass;
    protected String tableName;
    private final String hqlCount;
    private final String hqlDeleteAll;
    private final String hqlFindAll;

    public GenericHibernateDaoSupport() {
        this.hqlCount = "select count(*) from " + this.tableName + " x";
        this.hqlDeleteAll = "delete " + this.tableName;
        this.hqlFindAll = "from " + this.tableName + " x";
        ParameterizedType genericSuperclass = (ParameterizedType)this.getClass().getGenericSuperclass();
        this.infoClass = (Class)genericSuperclass.getActualTypeArguments()[0];
        this.keyClass = (Class)genericSuperclass.getActualTypeArguments()[1];
        this.tableName = this.infoClass.getName();
    }

    public Class<INFO_TYPE> getInfoClass() {
        return this.infoClass;
    }

    public Class<KEY_TYPE> getKeyClass() {
        return this.keyClass;
    }

    public INFO_TYPE get(KEY_TYPE id) {
        return (INFO_TYPE)((BaseModelInfo)this.getHibernateTemplate().get(this.getInfoClass(), (Serializable)id));
    }

    public void update(INFO_TYPE infoObj) {
        this.getHibernateTemplate().update(infoObj);
    }

    public KEY_TYPE save(INFO_TYPE infoObj) {
        ((BaseModelInfo)infoObj).stampWhenCreated();
        Serializable key = this.getHibernateTemplate().save(infoObj);
        ((BaseModelInfo)infoObj).logCreateEvent();
        return (KEY_TYPE)key;
    }

    public void evict(INFO_TYPE infoObj) {
        this.getHibernateTemplate().evict(infoObj);
    }

    public INFO_TYPE merge(INFO_TYPE infoObj) {
        return (INFO_TYPE)((BaseModelInfo)this.getHibernateTemplate().merge(infoObj));
    }

    public KEY_TYPE saveOrUpdate(INFO_TYPE infoObj) {
        if (this.get((Serializable)((BaseModelInfo)infoObj).getId()) == null) {
            return this.save(infoObj);
        }
        this.update(infoObj);
        return (KEY_TYPE)((Serializable)((BaseModelInfo)infoObj).getId());
    }

    public void saveAll(Collection<INFO_TYPE> infoList) {
        for (BaseModelInfo infoObj : infoList) {
            infoObj.stampWhenCreated();
        }
        this.saveOrUpdateAll(infoList);
        for (BaseModelInfo infoObj : infoList) {
            infoObj.logCreateEvent();
        }
    }

    public void saveOrUpdateAll(Collection<INFO_TYPE> infoList) {
        if (infoList != null && !infoList.isEmpty()) {
            this.getHibernateTemplate().saveOrUpdateAll(infoList);
        }
    }

    public void delete(INFO_TYPE infoObj) {
        this.getHibernateTemplate().delete(infoObj);
    }

    public List<INFO_TYPE> getList() {
        return this.getHibernateTemplate().find(this.hqlFindAll);
    }

    public List<INFO_TYPE> getByIds(String idPropName, Collection<KEY_TYPE> ids) {
        return this.getSession().createCriteria(this.infoClass).add(Restrictions.in(idPropName, ids)).list();
    }

    public void deleteById(KEY_TYPE id) {
        INFO_TYPE obj = this.get(id);
        this.getHibernateTemplate().delete(obj);
    }

    public void deleteAll(Collection<INFO_TYPE> entities) {
        this.getHibernateTemplate().deleteAll(entities);
    }

    public void deleteAll() {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                int deletedEntities = session.createQuery(GenericHibernateDaoSupport.this.hqlDeleteAll).executeUpdate();
                return null;
            }
        });
    }

    public int count() {
        return (Integer)this.queryFirst(this.hqlCount);
    }

    public <T> T queryFirst(String hql) {
        return this.query(hql).get(0);
    }

    public <T> List<T> query(String hql) {
        return this.getHibernateTemplate().find(hql);
    }
}

