/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.persistence.dao;

import java.util.List;
import org.gwe.persistence.dao.BaseInfoDAO;
import org.gwe.persistence.model.AllocationInfo;
import org.gwe.persistence.model.JobInfo;
import org.hibernate.Criteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobInfoDAO
extends BaseInfoDAO<JobInfo, String> {
    private final String hqlPendingCount;

    public JobInfoDAO() {
        this.hqlPendingCount = "select count(*) from " + this.tableName + " x where runningDaemon.location = " + this.daemonLocation + " and whenAssigned = null";
    }

    public List<JobInfo> getNextSchedulableJobsBatch(int size) {
        List result = this.getPendingJobsCriteria().addOrder(Order.asc("whenCreated")).setMaxResults(size).list();
        return result;
    }

    public int getPendingJobsCount() {
        ProjectionList projections = Projections.projectionList().add(Projections.rowCount());
        Criteria criteria = this.getPendingJobsCriteria().setProjection(projections);
        return (Integer)criteria.list().get(0);
    }

    private Criteria getPendingJobsCriteria() {
        return this.getSession().createCriteria(JobInfo.class).add(Restrictions.eq("runningDaemon.location", this.daemonLocation)).add(Restrictions.isNull("whenStarted"));
    }

    public List<JobInfo> getJobsProcessed(AllocationInfo alloc) {
        return this.getSession().createCriteria(JobInfo.class).add(Restrictions.eq("allocation", alloc)).list();
    }
}

