/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.persistence.model;

import java.sql.Timestamp;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.gwe.persistence.model.BaseModelInfo;
import org.gwe.persistence.model.ComputeResourceInfo;
import org.gwe.persistence.model.EventType;
import org.gwe.persistence.model.HeadResourceInfo;
import org.gwe.persistence.model.JobInfo;
import org.gwe.persistence.model.ModelSummary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class AllocationInfo
extends BaseModelInfo<Integer> {
    private static final int RELEASE_REASON_ERROR = 0;
    private static final int RELEASE_REASON_NON_RESPONSIVE = 1;
    private static final int RELEASE_REASON_TOO_IDLE = 2;
    private static final int RELEASE_REASON_TOO_OLD = 3;
    private static final int RELEASE_REASON_DAEMON_STOPPING = 4;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private int id;
    @ManyToOne
    private HeadResourceInfo headResource;
    protected String systemPid = null;
    @Transient
    private ComputeResourceInfo compResource;
    private Timestamp whenScheduled = null;
    private Timestamp whenAttained = null;
    private Timestamp whenReleased = null;
    private Timestamp whenDisposed = null;
    private int releaseReason;
    @Transient
    private transient Object lifeControllerLock = new Object();
    @Transient
    private transient JobInfo processingJob = null;
    @Transient
    private transient DeathDealer deathDealer;
    @Transient
    private transient boolean registered = false;

    public AllocationInfo(HeadResourceInfo cluster) {
        this.headResource = cluster;
        this.headResource.addAllocation(this);
    }

    public AllocationInfo() {
    }

    public HeadResourceInfo getHeadResource() {
        return this.headResource;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getSystemPid() {
        return this.systemPid;
    }

    public void setSystemPid(String pid) {
        this.systemPid = pid;
        this.whenScheduled = this.logEvent(EventType.ALLOCATION_SCHEDULED, new BaseModelInfo[0]);
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public Timestamp getWhenScheduled() {
        return this.whenScheduled;
    }

    public Timestamp getWhenAttained() {
        return this.whenAttained;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getWhenReleased() {
        Object object = this.lifeControllerLock;
        synchronized (object) {
            return this.whenReleased;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getWhenDisposed() {
        Object object = this.lifeControllerLock;
        synchronized (object) {
            return this.whenDisposed;
        }
    }

    public String getWorkspacePath() {
        return this.getWorkspacePath(null);
    }

    public String getWorkspacePath(String subFolderName) {
        if (subFolderName == null) {
            subFolderName = "";
        }
        if (!subFolderName.equals("") && !subFolderName.startsWith("/")) {
            subFolderName = "/" + subFolderName;
        }
        return this.headResource.getAllocWorkspacePath(this.getId()) + subFolderName;
    }

    public ComputeResourceInfo getCompResource() {
        return this.compResource;
    }

    public void setCompResource(ComputeResourceInfo compRes) {
        this.compResource = compRes;
        this.registered = true;
        this.whenAttained = this.logEvent(EventType.ALLOCATION_ATTAINED, new BaseModelInfo[0]);
    }

    public DeathDealer getDeathDealer() {
        this.deathDealer = new DeathDealer();
        return this.deathDealer;
    }

    public int getReleaseReason() {
        return this.releaseReason;
    }

    public void setReleaseReason(int reason) {
        this.releaseReason = reason;
        this.whenReleased = this.logEvent(EventType.ALLOCATION_RELEASED, new BaseModelInfo[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobInfo extractProcessingJob() {
        Object object = this.lifeControllerLock;
        synchronized (object) {
            JobInfo result = this.processingJob;
            this.processingJob = null;
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobInfo getNextProcessingJobBlocking() {
        Object object = this.lifeControllerLock;
        synchronized (object) {
            while (this.processingJob == null && this.whenReleased == null) {
                try {
                    this.lifeControllerLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return this.processingJob;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setProcessingJob(JobInfo processingJob) {
        Object object = this.lifeControllerLock;
        synchronized (object) {
            if (this.whenReleased != null) {
                return false;
            }
            this.processingJob = processingJob;
            processingJob.setAllocation(this);
            this.cancelIdleCountdown();
            this.lifeControllerLock.notifyAll();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobInfo dispose(boolean beatOverdue) {
        Object object = this.lifeControllerLock;
        synchronized (object) {
            if (this.whenReleased == null) {
                this.setReleaseReason(beatOverdue ? 1 : 0);
            }
            this.whenDisposed = this.logEvent(EventType.ALLOCATION_DISPOSED, new BaseModelInfo[0]);
            this.lifeControllerLock.notifyAll();
            return this.processingJob;
        }
    }

    public void startIdleCountdown() {
        this.deathDealer.setIdleDeathTime(System.currentTimeMillis() + this.headResource.getMaxIdleMillis());
    }

    public void cancelIdleCountdown() {
        this.deathDealer.setIdleDeathTime(-1L);
    }

    @Override
    public ModelSummary<Integer> createModelSummaryFor(EventType ev) {
        switch (ev) {
            case ALLOCATION_RELEASED: {
                return new ModelSummary<Integer>(this, Integer.valueOf(this.releaseReason));
            }
        }
        return super.createModelSummaryFor(ev);
    }

    public String toString() {
        return "allocId:" + this.getId();
    }

    static /* synthetic */ Timestamp access$100(AllocationInfo x0) {
        return x0.whenAttained;
    }

    class DeathDealer
    implements Runnable {
        private long idleDeathTime = -1L;
        private long oldDeathTime = AllocationInfo.access$100(AllocationInfo.this).getTime() + AllocationInfo.access$200(AllocationInfo.this).getMaxHijackMillis();

        DeathDealer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setIdleDeathTime(long time) {
            Object object = AllocationInfo.this.lifeControllerLock;
            synchronized (object) {
                this.idleDeathTime = time;
                AllocationInfo.this.lifeControllerLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (AllocationInfo.this.headResource.getMaxHijackMillis() <= 0L && AllocationInfo.this.headResource.getMaxIdleMillis() <= 0L) {
                return;
            }
            Object object = AllocationInfo.this.lifeControllerLock;
            synchronized (object) {
                boolean isIdleCutTime;
                long remaining;
                while ((remaining = ((isIdleCutTime = 0L <= this.idleDeathTime && this.idleDeathTime <= this.oldDeathTime) ? this.idleDeathTime : this.oldDeathTime) - System.currentTimeMillis()) >= 0L) {
                    try {
                        AllocationInfo.this.lifeControllerLock.wait(remaining);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (AllocationInfo.this.whenReleased == null && AllocationInfo.this.whenDisposed == null) continue;
                    break;
                }
                if (AllocationInfo.this.whenReleased == null) {
                    AllocationInfo.this.setReleaseReason(isIdleCutTime ? 2 : 3);
                    AllocationInfo.this.lifeControllerLock.notifyAll();
                }
            }
        }
    }
}

