/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.persistence.model;

import java.io.Serializable;
import java.sql.Timestamp;
import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import org.gwe.GWEAppContext;
import org.gwe.persistence.model.EventType;
import org.gwe.persistence.model.ModelSummary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MappedSuperclass
public abstract class BaseModelInfo<KEY_TYPE>
implements Serializable {
    @Column
    private Timestamp whenCreated;

    public abstract KEY_TYPE getId();

    public Timestamp getWhenCreated() {
        return this.whenCreated;
    }

    public void stampWhenCreated() {
        this.whenCreated = new Timestamp(System.currentTimeMillis());
    }

    public void logCreateEvent() {
        GWEAppContext.getInstance().getEventLogger().logEvent(this, EventType.CREATED, this.getWhenCreated(), new BaseModelInfo[0]);
    }

    public Timestamp logEvent(EventType evType, BaseModelInfo ... relatedModels) {
        return this.logEvent(evType, new Timestamp(System.currentTimeMillis()), relatedModels);
    }

    public Timestamp logEvent(EventType evType, Timestamp when, BaseModelInfo ... relatedModels) {
        return GWEAppContext.getInstance().getEventLogger().logEvent(this, evType, when, relatedModels);
    }

    public ModelSummary<KEY_TYPE> createModelSummaryFor(EventType ev) {
        return new ModelSummary(this, new Serializable[0]);
    }
}

