/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.persistence.model;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import org.gwe.persistence.model.BaseModelInfo;
import org.gwe.persistence.model.HeadResourceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class ComputeResourceInfo
extends BaseModelInfo<String> {
    @Id
    private String hostAddress;
    private String hostName;
    private String javaVersion;
    private String osName;
    private String osVersion;
    private int osProcessors;
    private String osArch;
    @ManyToOne
    private HeadResourceInfo headResource;

    public static ComputeResourceInfo createLocalInfo(int allocationId) {
        String hostAddress;
        String hostName = hostAddress = "UNKNOWN-FOR-ALLOCATION-ID-" + allocationId;
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            hostAddress = localhost.getHostAddress();
            hostName = localhost.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return new ComputeResourceInfo(hostAddress, hostName, System.getProperty("java.version"), Runtime.getRuntime().availableProcessors(), System.getProperty("os.arch"), System.getProperty("os.name"), System.getProperty("os.version"));
    }

    public ComputeResourceInfo(String hostAddress, String hostName, String javaVersion, int osProcessors, String osArch, String osName, String osVersion) {
        this.hostAddress = hostAddress;
        this.hostName = hostName;
        this.javaVersion = javaVersion;
        this.osProcessors = osProcessors;
        this.osArch = osArch;
        this.osName = osName;
        this.osVersion = osVersion;
    }

    public ComputeResourceInfo() {
    }

    @Override
    public String getId() {
        return this.hostAddress;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public int getOsProcessors() {
        return this.osProcessors;
    }

    public String getOsArch() {
        return this.osArch;
    }

    public String getOsName() {
        return this.osName;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public HeadResourceInfo getHeadResource() {
        return this.headResource;
    }

    public void setHeadResource(HeadResourceInfo headResource) {
        this.headResource = headResource;
    }
}

