/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.persistence.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwe.persistence.model.BaseModelInfo;
import org.gwe.persistence.model.HeadResourceInfo;
import org.gwe.persistence.model.OrderInfo;
import org.gwe.persistence.model.UserInfo;
import org.hibernate.annotations.GenericGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GenericGenerator(name="gridInfoIdGenerator", strategy="org.gwe.persistence.model.GridInfoIdGenerator")
@Entity
public class GridInfo
extends BaseModelInfo<String> {
    private static Log log = LogFactory.getLog(GridInfo.class);
    @Id
    @GeneratedValue(generator="gridInfoIdGenerator")
    private String id;
    private String name;
    @ManyToOne(fetch=FetchType.EAGER)
    private UserInfo owner;
    @ManyToMany(fetch=FetchType.EAGER)
    private List<HeadResourceInfo> headResources = new ArrayList<HeadResourceInfo>();
    @OneToMany
    private Set<OrderInfo> orders = new HashSet<OrderInfo>();

    public static String generateId(UserInfo ownerInfo, String gridName) {
        String ownerName = ownerInfo != null ? ownerInfo.getName() : "";
        return "[" + ownerName + "]::[" + gridName + "]";
    }

    public GridInfo() {
    }

    public GridInfo(String name, UserInfo owner, List<HeadResourceInfo> headResources) {
        this.setName(name);
        this.setOwner(owner);
        this.headResources = headResources;
        owner.getGrids().add(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    private void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UserInfo getOwner() {
        return this.owner;
    }

    private void setOwner(UserInfo owner) {
        this.owner = owner;
    }

    public List<HeadResourceInfo> getHeadResources() {
        return this.headResources;
    }

    public HeadResourceInfo getHeadResource(String name) {
        if (name != null && !"".equals(name)) {
            for (HeadResourceInfo daemon : this.headResources) {
                if (!name.equals(daemon.getName())) continue;
                return daemon;
            }
        }
        return null;
    }

    public void setHeadResources(List<HeadResourceInfo> hrList) {
        this.headResources = new ArrayList<HeadResourceInfo>(hrList);
    }

    public void addHeadResource(HeadResourceInfo daemon) {
        this.headResources.add(daemon);
    }

    public void add(HeadResourceInfo daemon) {
        this.addHeadResource(daemon);
    }

    public Set<OrderInfo> getOrders() {
        return this.orders;
    }

    public void setOrders(Set<OrderInfo> orders) {
        this.orders = orders;
    }

    public void addOrder(OrderInfo order) {
        this.orders.add(order);
    }

    public boolean contains(HeadResourceInfo targetHeadInfo) {
        if (targetHeadInfo == null) {
            return false;
        }
        String locationTarget = targetHeadInfo.getLocation();
        for (HeadResourceInfo headInfo : this.getHeadResources()) {
            if (!locationTarget.equals(headInfo.getLocation())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "\"" + this.name + " by " + this.owner + "\"";
    }
}

