/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.persistence.model;

import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwe.drivers.osAppManagers.JavaOSAppHandle;
import org.gwe.drivers.osAppManagers.OSAppFolder;
import org.gwe.persistence.model.AllocationInfo;
import org.gwe.persistence.model.BaseModelInfo;
import org.gwe.persistence.model.ComputeResourceInfo;
import org.gwe.persistence.model.HeadResourceInfoIdGenerator;
import org.gwe.persistence.model.PlatformType;
import org.gwe.persistence.model.UserInfo;
import org.hibernate.annotations.GenericGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GenericGenerator(name="headResourceInfoIdGenerator", strategy="org.gwe.persistence.model.HeadResourceInfoIdGenerator")
@Entity
public class HeadResourceInfo
extends BaseModelInfo<String> {
    private static Log log = LogFactory.getLog(HeadResourceInfo.class);
    public static final int DEFAULT_RMI_REGISTRY_PORT = 1099;
    private static final String LINK_FILENAME = "daemonLink.ser";
    @Id
    @GeneratedValue(generator="headResourceInfoIdGenerator")
    private String location = null;
    private String name = "";
    private String host;
    private int registryPort = 1099;
    @ManyToOne
    private UserInfo admin = null;
    private String spoolDir;
    private String compURI;
    private String dataURI;
    private int queueSize = -1;
    private long maxHijackMillis = -1L;
    private long maxIdleMillis = -1L;
    private long heartBeatPeriodMillis;
    @Lob
    @Column(length=8192)
    private String computeNodesAddresses = null;
    @Lob
    @Column(length=8192)
    private JavaOSAppHandle daemonOSApp;
    @OneToMany
    private Set<ComputeResourceInfo> computeResources = new HashSet<ComputeResourceInfo>();
    @OneToMany
    private Set<AllocationInfo> allocations = new HashSet<AllocationInfo>();
    private PlatformType platform;

    public HeadResourceInfo(int port) throws UnknownHostException {
        this(InetAddress.getLocalHost().getHostAddress(), port);
    }

    public HeadResourceInfo(String name, String host, int port, int maxConcurrentAllocations, long maxHijackMin, long maxIdleMin) {
        this(host, port);
        this.setName(name);
        this.setMaxHijackMillis(maxHijackMin * 60000L);
        this.setMaxIdleMillis(maxIdleMin * 60000L);
        this.setQueueSize(maxConcurrentAllocations);
    }

    public HeadResourceInfo(String host, int port) {
        this.setHost(host);
        this.setRegistryPort(port);
    }

    public HeadResourceInfo() {
        this.setRegistryPort(1099);
    }

    public HeadResourceInfo(String daemonLocation) throws URISyntaxException {
        this(new URI(daemonLocation).getHost(), new URI(daemonLocation).getPort());
    }

    @Override
    public String getId() {
        return this.getLocation();
    }

    public Object[] toAgentArgs(AllocationInfo alloc) {
        return new Object[]{this.host, this.registryPort, this.getLinkSerializedFilePath(), alloc.getId(), alloc.getWorkspacePath()};
    }

    public String getLocation() {
        return this.location == null ? new HeadResourceInfoIdGenerator().generateId(this) : this.location;
    }

    private void setLocation(String location) {
        this.location = location;
        if (this.name == null || "".equals(this.name)) {
            this.name = location;
        }
    }

    public String getHost() {
        return this.host;
    }

    private void setHost(String host) {
        this.host = host;
        this.assertCompURINotNull();
    }

    private void assertCompURINotNull() {
        if (this.compURI == null) {
            this.compURI = "ssh://" + this.host;
        }
    }

    public int getRegistryPort() {
        return this.registryPort;
    }

    public void setRegistryPort(int port) {
        this.registryPort = port;
    }

    public UserInfo getAdmin() {
        return this.admin;
    }

    public void setAdmin(UserInfo user) {
        this.admin = user;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name != null) {
            this.name = name;
        }
    }

    public String getSpoolDir() {
        return this.spoolDir;
    }

    public void setSpoolDir(String spoolDir) {
        this.spoolDir = spoolDir;
    }

    public String getAllocWorkspacePath(int id) {
        return this.getWorkspacePath() + "/alloc-" + id;
    }

    public String getWorkspacePath() {
        String wsRoot = this.getSpoolDir();
        return wsRoot != null ? wsRoot : this.daemonOSApp.getFolderFullPath(OSAppFolder.WORKSPACE);
    }

    public String getCompURI() {
        this.assertCompURINotNull();
        return this.compURI;
    }

    public void setCompURI(String compURI) {
        this.compURI = compURI;
    }

    public String getDataURI() {
        return this.dataURI;
    }

    public void setDataURI(String dataURI) {
        this.dataURI = dataURI;
    }

    public Set<ComputeResourceInfo> getComputeResources() {
        return this.computeResources;
    }

    public void associateComputeResource(ComputeResourceInfo compRes) {
        compRes.setHeadResource(this);
        this.getComputeResources().add(compRes);
    }

    public Set<AllocationInfo> getAllocations() {
        return this.allocations;
    }

    public void addAllocation(AllocationInfo alloc) {
        this.allocations.add(alloc);
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public long getMaxHijackMillis() {
        return this.maxHijackMillis;
    }

    public void setMaxHijackMillis(long value) {
        this.maxHijackMillis = value;
    }

    public long getMaxIdleMillis() {
        return this.maxIdleMillis;
    }

    public void setMaxIdleMillis(long value) {
        this.maxIdleMillis = value;
    }

    public long getHeartBeatPeriodMillis() {
        return this.heartBeatPeriodMillis;
    }

    public void setHeartBeatPeriodMillis(long value) {
        this.heartBeatPeriodMillis = value;
    }

    public PlatformType getPlatform() {
        return this.platform;
    }

    public void setPlatform(PlatformType platform) {
        this.platform = platform;
    }

    public JavaOSAppHandle getDaemonOSApp() {
        return this.daemonOSApp;
    }

    public void setDaemonOSApp(JavaOSAppHandle osApp) {
        this.daemonOSApp = osApp;
    }

    public String getLinkSerializedFilePath() {
        return this.daemonOSApp.getFolderFullPath(OSAppFolder.LIBRARIES) + "/" + LINK_FILENAME;
    }

    public String toString() {
        return this.name + "->" + this.location;
    }

    public int hashCode() {
        return this.location.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HeadResourceInfo other = (HeadResourceInfo)obj;
        return this.location.equals(other.location);
    }

    public long getMaxHijackSecs() {
        return this.maxHijackMillis / 1000L;
    }

    public void setMaxHijackSecs(long value) {
        this.maxHijackMillis = value * 1000L;
    }

    public long getMaxIdleSecs() {
        return this.maxIdleMillis / 1000L;
    }

    public void setMaxIdleSecs(long value) {
        this.maxIdleMillis = value * 1000L;
    }

    public long getHeartBeatPeriodSecs() {
        return this.heartBeatPeriodMillis / 1000L;
    }

    public void setHeartBeatPeriodSecs(long value) {
        this.heartBeatPeriodMillis = value * 1000L;
    }
}

