/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.persistence.model;

import java.io.Serializable;
import java.sql.Timestamp;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwe.persistence.model.AllocationInfo;
import org.gwe.persistence.model.BaseModelInfo;
import org.gwe.persistence.model.EventType;
import org.gwe.persistence.model.HeadResourceInfo;
import org.gwe.persistence.model.ModelSummary;
import org.gwe.persistence.model.OrderInfo;
import org.gwe.persistence.model.order.DaemonRequest;
import org.gwe.persistence.model.order.OrderRuntimeController;
import org.gwe.utils.CompressedObject;
import org.gwe.utils.CompressionException;
import org.hibernate.annotations.GenericGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GenericGenerator(name="jobInfoIdGenerator", strategy="org.gwe.persistence.model.JobInfoIdGenerator")
@Entity
public class JobInfo
extends BaseModelInfo<String> {
    private static final String IDS_SEPARATOR = "_";
    private static Log log = LogFactory.getLog(JobInfo.class);
    @Id
    @GeneratedValue(generator="jobInfoIdGenerator")
    private String id;
    @ManyToOne(fetch=FetchType.LAZY)
    protected OrderInfo order;
    private int jobNum;
    @ManyToOne(fetch=FetchType.EAGER)
    protected HeadResourceInfo runningDaemon;
    @ManyToOne(fetch=FetchType.LAZY)
    protected AllocationInfo allocation = null;
    private Timestamp whenStarted = null;
    private Timestamp whenPrepared = null;
    private Timestamp whenAssigned = null;
    private Timestamp whenDispatched = null;
    private Timestamp whenProcessed = null;
    private Timestamp whenCompleted = null;
    private Timestamp whenFailed = null;
    @Lob
    @Column(length=327680)
    private CompressedObject compressedResult = new CompressedObject();
    @Lob
    @Column(length=32768)
    protected DaemonRequest<?> request;
    @Transient
    protected String orderWorkspace;

    public static String generateId(Integer orderId, int jobNum) {
        return orderId + IDS_SEPARATOR + jobNum;
    }

    public static Integer extractOrderId(String jobId) {
        return Integer.parseInt(jobId.split(IDS_SEPARATOR)[0]);
    }

    public JobInfo() {
    }

    public JobInfo(DaemonRequest<?> daemonRequest) {
        this.request = daemonRequest;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public OrderInfo getOrder() {
        return this.order;
    }

    public void setOrder(OrderInfo order) {
        this.order = order;
    }

    public int getJobNum() {
        return this.jobNum;
    }

    public void setJobNum(int jobNum) {
        this.jobNum = jobNum;
    }

    public HeadResourceInfo getRunningDaemon() {
        return this.runningDaemon;
    }

    public void setRunningDaemon(HeadResourceInfo runningDaemon) {
        this.runningDaemon = runningDaemon;
    }

    public AllocationInfo getAllocation() {
        return this.allocation;
    }

    public void setOrderWorkspace(String orderWorkspace) {
        this.orderWorkspace = orderWorkspace;
    }

    public String getWorkspacePath() {
        return this.orderWorkspace + "/job-" + this.getId();
    }

    public void flagAsStarted() {
        this.whenCompleted = null;
        this.whenProcessed = null;
        this.whenDispatched = null;
        this.whenAssigned = null;
        this.whenPrepared = null;
        this.whenStarted = this.logJobEvent(EventType.JOB_STARTED);
    }

    public Runnable createPreparingRunnable(final OrderRuntimeController orderRC) {
        return new Runnable(){

            public void run() {
                JobInfo.this.preProcessInDaemonInternal(orderRC);
            }
        };
    }

    public boolean hasFailed() {
        return this.whenFailed != null;
    }

    public boolean hasCompleted() {
        return this.whenCompleted != null;
    }

    public void setAllocation(AllocationInfo alloc) {
        this.allocation = alloc;
        this.whenAssigned = this.logJobEvent(EventType.JOB_ASSIGNED);
    }

    public void flagAsDispatched() {
        this.whenDispatched = this.logJobEvent(EventType.JOB_DISPATCHED);
    }

    public Serializable getRequestResult() {
        try {
            return this.compressedResult.getTarget();
        }
        catch (CompressionException e) {
            return null;
        }
    }

    public Timestamp getWhenAssigned() {
        return this.clone(this.whenAssigned);
    }

    public Timestamp getWhenStarted() {
        return this.clone(this.whenStarted);
    }

    public Timestamp getWhenPrepared() {
        return this.clone(this.whenPrepared);
    }

    public Timestamp getWhenDispatched() {
        return this.clone(this.whenDispatched);
    }

    public Timestamp getWhenProcessed() {
        return this.clone(this.whenProcessed);
    }

    public Timestamp getWhenCompleted() {
        return this.clone(this.whenCompleted);
    }

    public Timestamp getWhenFailed() {
        return this.clone(this.whenFailed);
    }

    public void preProcessInDaemonInternal(OrderRuntimeController orderRC) {
        try {
            this.request.setJobId(this.getId());
            this.request.setKeys(orderRC.getOrder().getKeyStore());
            this.preProcessInDaemon(orderRC);
            this.whenPrepared = this.logJobEvent(EventType.JOB_PREPARED);
        }
        catch (Exception e) {
            this.whenFailed = this.setResultAndLogEvent(e, EventType.JOB_FAILED);
        }
    }

    public void postProcessInDaemonInternal(OrderRuntimeController orderRC, Serializable result) {
        try {
            if (result instanceof Exception) {
                this.whenFailed = this.setResultAndLogEvent(result, EventType.JOB_FAILED);
                this.postProcessInDaemon(orderRC);
            } else {
                this.whenProcessed = this.setResultAndLogEvent(result, EventType.JOB_PROCESSED);
                this.postProcessInDaemon(orderRC);
                this.whenCompleted = this.setResultAndLogEvent(this.getOrder().createResultParser().parseResult(this.getRequestResult()), EventType.JOB_COMPLETED);
            }
        }
        catch (Exception e) {
            this.whenFailed = this.setResultAndLogEvent(e, EventType.JOB_FAILED);
        }
    }

    public long getComputeTime() {
        long endTime = 0L;
        if (this.whenProcessed != null && this.whenFailed == null) {
            endTime = this.whenProcessed.getTime();
        }
        if (this.whenProcessed == null && this.whenFailed != null) {
            endTime = this.whenFailed.getTime();
        }
        return endTime == 0L ? 0L : endTime - this.whenStarted.getTime();
    }

    private Timestamp setResultAndLogEvent(Serializable result, EventType evType) {
        this.setRequestResult(result);
        return this.logJobEvent(evType);
    }

    public void setRequestResult(Serializable result) {
        try {
            this.compressedResult.setTarget(result);
        }
        catch (CompressionException e) {
            String msg = "Unusual IOException error caught trying to create a serialized stream of an object";
            log.warn(msg);
            throw new RuntimeException(msg, e.getCause());
        }
    }

    public DaemonRequest<?> getRequest() {
        return this.request;
    }

    public void preProcessInDaemon(OrderRuntimeController orderRC) throws Exception {
    }

    public void postProcessInDaemon(OrderRuntimeController orderRC) throws Exception {
    }

    private Timestamp clone(Timestamp source) {
        return source != null ? new Timestamp(source.getTime()) : null;
    }

    @Override
    public void logCreateEvent() {
        this.logEvent(EventType.CREATED, this.getWhenCreated(), this.getOrder());
    }

    private Timestamp logJobEvent(EventType evType) {
        OrderInfo or = this.getOrder();
        Timestamp result = this.logEvent(evType, or);
        return result;
    }

    @Override
    public ModelSummary<String> createModelSummaryFor(EventType ev) {
        switch (ev) {
            case JOB_ASSIGNED: {
                return new ModelSummary<String>(this, this.allocation.getId());
            }
        }
        return super.createModelSummaryFor(ev);
    }

    public String toString() {
        return "jobId:" + this.getId();
    }

    public int getOrderId() {
        return JobInfo.extractOrderId(this.id);
    }
}

