/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.persistence.model;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwe.persistence.model.BaseModelInfo;
import org.gwe.persistence.model.EventType;
import org.gwe.persistence.model.GridInfo;
import org.gwe.persistence.model.HeadResourceInfo;
import org.gwe.persistence.model.JobInfo;
import org.gwe.persistence.model.ResultParser;
import org.gwe.persistence.model.UserInfo;
import org.gwe.persistence.model.order.JobsDescriptor;
import org.gwe.utils.security.KeyStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public final class OrderInfo
extends BaseModelInfo<Integer> {
    private static Log log = LogFactory.getLog(OrderInfo.class);
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private int id;
    private String userOrderId;
    @ManyToOne(fetch=FetchType.EAGER)
    private UserInfo owner;
    private String description;
    private String email;
    @ManyToOne(fetch=FetchType.EAGER)
    private GridInfo grid;
    @Lob
    @Column(length=20480)
    private JobsDescriptor jobsDescriptor;
    @Lob
    @Column(length=4096)
    private Serializable specificParameters = null;
    private Timestamp whenCompleted = null;
    private boolean paused = false;
    private boolean aborted = false;
    private boolean failed = false;
    private int totalJobsCount = 0;
    private int finishedJobsCount = 0;
    @OneToMany
    private List<JobInfo> jobs;
    private Class<? extends ResultParser> resultParserClass = ResultParser.class;

    public OrderInfo() {
    }

    public OrderInfo(JobsDescriptor jobDescriptor) {
        this(null, jobDescriptor, null);
    }

    public OrderInfo(JobsDescriptor jobDescriptor, String email) {
        this(null, jobDescriptor, email);
    }

    public OrderInfo(String userOrderId, JobsDescriptor jobDescriptor, String email) {
        this(null, "Order from " + email, jobDescriptor, email);
    }

    public OrderInfo(String userOrderId, String description, JobsDescriptor jobDescriptor, String email) {
        this.userOrderId = userOrderId;
        this.description = description;
        this.jobsDescriptor = jobDescriptor;
        this.email = email;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    private void setId(int id) {
        this.id = id;
    }

    public String getUserOrderId() {
        return this.userOrderId;
    }

    public void setUserOrderId(String userId) {
        this.userOrderId = userId;
    }

    public GridInfo getGrid() {
        return this.grid;
    }

    public void setGrid(GridInfo grid) {
        this.grid = grid;
    }

    public UserInfo getOwner() {
        return this.owner;
    }

    public void setOwner(UserInfo owner) {
        this.owner = owner;
        if (this.email == null) {
            this.email = owner.getEmail();
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public JobsDescriptor getJobsDescriptor() {
        return this.jobsDescriptor;
    }

    public void setJobsDescriptor(JobsDescriptor jobDescriptor) {
        this.jobsDescriptor = jobDescriptor;
    }

    public List<JobInfo> getJobs() {
        return this.jobs;
    }

    public List<JobInfo> generateJobs(HeadResourceInfo daemonInfo) {
        int count = 1;
        try {
            this.jobs = this.jobsDescriptor.generateJobs(this.owner);
        }
        catch (Exception e) {
            this.jobs = new ArrayList<JobInfo>();
            this.failed = true;
        }
        for (JobInfo job : this.jobs) {
            job.setJobNum(count++);
            job.setOrder(this);
            job.setRunningDaemon(daemonInfo);
        }
        this.totalJobsCount = this.jobs.size();
        this.logEvent(EventType.ORDER_EXPANDED, this.jobs.toArray(new BaseModelInfo[0]));
        this.checkIfCompleted();
        return this.jobs;
    }

    public KeyStore getKeyStore() {
        return this.owner.getKeyStore();
    }

    public Serializable getSpecificParameters() {
        return this.specificParameters;
    }

    public void setSpecificParameters(Serializable specificParameters) {
        this.specificParameters = specificParameters;
    }

    public ResultParser createResultParser() throws InstantiationException, IllegalAccessException {
        return this.resultParserClass.newInstance();
    }

    public Class<? extends ResultParser> getResultParserClass() {
        return this.resultParserClass;
    }

    public void setResultParserClass(Class<? extends ResultParser> resultParserClass) {
        this.resultParserClass = resultParserClass;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public void setAborted(boolean aborted) {
        this.aborted = aborted;
    }

    public String toString() {
        return this.getJobsDescriptor() + "\nTo be executed by " + this.getGrid();
    }

    public Timestamp getWhenCompleted() {
        return this.whenCompleted;
    }

    public void setWhenCompleted(Timestamp whenCompleted) {
        this.whenCompleted = whenCompleted;
    }

    public void incrementJobsFinished(int amount) {
        this.finishedJobsCount += amount;
        this.checkIfCompleted();
    }

    private void checkIfCompleted() {
        if (this.isFinished()) {
            this.whenCompleted = this.logEvent(EventType.ORDER_COMPLETED, new BaseModelInfo[0]);
        }
    }

    public boolean isFinished() {
        return this.finishedJobsCount >= this.totalJobsCount;
    }

    public int getTotalJobsCount() {
        return this.totalJobsCount;
    }

    public int getFinishedJobsCount() {
        return this.finishedJobsCount;
    }
}

