/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.persistence.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwe.persistence.model.BaseModelInfo;
import org.gwe.persistence.model.GridInfo;
import org.gwe.persistence.model.HeadResourceInfo;
import org.gwe.persistence.model.OrderInfo;
import org.gwe.utils.Encryptor;
import org.gwe.utils.IOUtils;
import org.gwe.utils.security.KeyStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class UserInfo
extends BaseModelInfo<String> {
    private static Log log = LogFactory.getLog(UserInfo.class);
    private static transient Encryptor daemonEncryptor = null;
    @Id
    private String name;
    @Transient
    private byte[] passwordHash = null;
    @Column(length=64)
    private String encryptedPasswordHash = "";
    @Column(length=32672)
    private String encryptedSerializedKeyStore;
    private String email;
    @OneToMany
    private List<OrderInfo> orders = new ArrayList<OrderInfo>();
    @OneToMany(fetch=FetchType.EAGER)
    private Set<GridInfo> grids = new HashSet<GridInfo>();

    private static Encryptor createDaemonEncryptor(UserInfo user, HeadResourceInfo daemonInfo) {
        return new Encryptor(new String(user.passwordHash) + "-" + daemonInfo.getHost());
    }

    public UserInfo() {
    }

    public UserInfo(UserInfo applyingUser, HeadResourceInfo daemonInfo) {
        this(applyingUser.name, applyingUser.passwordHash);
        if (daemonInfo.getAdmin() == null) {
            daemonInfo.setAdmin(this);
            daemonEncryptor = UserInfo.createDaemonEncryptor(this, daemonInfo);
        }
        try {
            this.setEncryptedPasswordHash(daemonEncryptor.encrypt(this.passwordHash));
        }
        catch (Exception e) {
            log.fatal("Problems securing password for user " + this.name, e);
        }
    }

    public UserInfo(String name, String password) {
        this(name, Encryptor.createMD5Hash(password));
    }

    public UserInfo(String name, byte[] passwordHash) {
        this.name = name;
        this.passwordHash = passwordHash;
    }

    @Override
    public String getId() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String ownerName) {
        this.name = ownerName;
    }

    public boolean isDaemonUserAdmin(UserInfo applyingUser, HeadResourceInfo daemonInfo) {
        Encryptor enc = UserInfo.createDaemonEncryptor(applyingUser, daemonInfo);
        boolean result = this.matchesPassword(applyingUser, enc);
        if (result) {
            daemonEncryptor = enc;
        }
        return result;
    }

    public boolean matchesPassword(UserInfo other) {
        return this.matchesPassword(other, daemonEncryptor);
    }

    private boolean matchesPassword(UserInfo other, Encryptor enc) {
        return Arrays.equals(other.passwordHash, this.getPasswordHash(enc));
    }

    public KeyStore getKeyStore() {
        try {
            String serKeys = this.getEncryptor().decrypt(this.getEncryptedSerializedKeyStore().getBytes());
            return (KeyStore)IOUtils.deserializeObject(serKeys.getBytes());
        }
        catch (Exception e) {
            log.warn("Problems deserializing key store for user " + this.name, e);
            return new KeyStore();
        }
    }

    public void setKeyStore(KeyStore keys) {
        try {
            byte[] serKeys = IOUtils.serializeObject(keys);
            this.setEncryptedSerializedKeyStore(this.getEncryptor().encrypt(serKeys));
        }
        catch (Exception e) {
            log.warn("Problems serializing key store for user " + this.name, e);
        }
    }

    private Encryptor getEncryptor() {
        return new Encryptor(this.getPasswordHash(daemonEncryptor));
    }

    private byte[] getPasswordHash(Encryptor enc) {
        String result = this.getEncryptedPasswordHash();
        if (result == null || result.length() == 0 || enc == null) {
            return this.passwordHash;
        }
        try {
            result = enc.decrypt(result.getBytes());
        }
        catch (Exception e) {
            log.fatal("Problems retrieving password for user " + this.name, e);
        }
        return result.getBytes();
    }

    private String getEncryptedPasswordHash() {
        return this.encryptedPasswordHash;
    }

    private void setEncryptedPasswordHash(String encryptedPasswordHash) {
        this.encryptedPasswordHash = encryptedPasswordHash;
    }

    private String getEncryptedSerializedKeyStore() {
        return this.encryptedSerializedKeyStore;
    }

    private void setEncryptedSerializedKeyStore(String encryptedSerializedKeyStore) {
        this.encryptedSerializedKeyStore = encryptedSerializedKeyStore;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public List<OrderInfo> getOrders() {
        return this.orders;
    }

    public void associateOrder(OrderInfo order, GridInfo grid) {
        order.setGrid(grid);
        grid.addOrder(order);
        order.setOwner(this);
        this.orders.add(order);
    }

    public Set<GridInfo> getGrids() {
        return this.grids;
    }

    public void addGrid(GridInfo grid) {
        this.grids.add(grid);
    }

    public GridInfo getDefinedGrid(String gridId) {
        for (GridInfo grid : this.getGrids()) {
            if (!grid.getId().equals(gridId)) continue;
            return grid;
        }
        return null;
    }

    public String toString() {
        return "User=" + this.name;
    }
}

