/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.persistence.model.order;

import org.gwe.persistence.model.HeadResourceInfo;
import org.gwe.persistence.model.OrderInfo;
import org.gwe.utils.security.AccountInfo;
import org.gwe.utils.security.Realm;

public class OrderRuntimeController {
    private OrderInfo order;
    private HeadResourceInfo localDaemonInfo;
    private String workspace;

    public OrderRuntimeController(OrderInfo order, HeadResourceInfo localDaemonInfo) {
        this.order = order;
        this.localDaemonInfo = localDaemonInfo;
        Realm sftpLocalRealm = new Realm("sftp", localDaemonInfo.getHost());
        AccountInfo workspaceAccount = order.getKeyStore().getAccountForRealm(sftpLocalRealm);
        this.workspace = workspaceAccount.getWorkspacePath() + "/order-" + order.getId() + "";
        order.getJobsDescriptor().prepareForJobsExecution(this);
    }

    public OrderInfo getOrder() {
        return this.order;
    }

    public HeadResourceInfo getLocalDaemonInfo() {
        return this.localDaemonInfo;
    }

    public String getWorkspacePathInCluster() {
        return this.workspace;
    }

    public void wrapUp() {
        this.order.getJobsDescriptor().wrapUpJobsExecution(this);
    }
}

