/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.persistence.model.order.shell;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwe.drivers.fileSystems.staging.FilesTransferDescriptor;
import org.gwe.drivers.fileSystems.staging.StagingDescriptor;
import org.gwe.utils.StringUtils;

public class CommandLocalizer {
    private static Log log = LogFactory.getLog(CommandLocalizer.class);
    private static final String IN_PREFIX = "in";
    private static final String OUT_PREFIX = "out";
    private FilesTransferDescriptor inRemoteFiles;
    private FilesTransferDescriptor outRemoteFiles;
    private String command;
    private StagingDescriptor stagingDescriptor;

    public CommandLocalizer(String cmd, String workspace) {
        this.command = cmd;
        this.stagingDescriptor = new StagingDescriptor(StringUtils.splitSpaceSeparated(cmd), workspace);
    }

    public String getLocalizedCommand() {
        String result = this.command;
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.putAll(this.inRemoteFiles.getFileTransfers(false));
        replacements.putAll(this.outRemoteFiles.getFileTransfers(false));
        for (String tokenToReplace : replacements.keySet()) {
            result = result.replace(tokenToReplace, (CharSequence)replacements.get(tokenToReplace));
        }
        return result;
    }

    public StagingDescriptor getStagingDescriptor() {
        return this.stagingDescriptor;
    }
}

