/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.persistence.model.order.shell;

import java.util.HashMap;
import java.util.Map;
import org.gwe.drivers.fileSystems.staging.FileStagingException;
import org.gwe.drivers.fileSystems.staging.FilesStager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSCommandModel {
    private FilesStager stager;
    private String command;
    private Map<String, String> downloads = new HashMap<String, String>();
    private Map<String, String> uploads = new HashMap<String, String>();

    public OSCommandModel(FilesStager stager, String command) {
        this(stager, command, new HashMap<String, String>(), new HashMap<String, String>());
    }

    public OSCommandModel(FilesStager stager, String command, Map<String, String> downloads, Map<String, String> uploads) {
        this.stager = stager;
        this.command = command;
        this.downloads = downloads;
        this.uploads = uploads;
    }

    public void addDownload(String localFile, String remoteFile) {
        this.downloads.put(localFile, remoteFile);
    }

    public void addUpload(String localFile, String remoteFile) {
        this.uploads.put(localFile, remoteFile);
    }

    public String getCommand() {
        return this.command;
    }

    public void prepare() throws FileStagingException {
        this.stager.downloadFiles(this.downloads);
        this.stager.prepareUploadDirectories(this.uploads);
    }

    public void wrapUp() throws FileStagingException {
        this.stager.uploadFiles(this.uploads);
    }
}

