/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.persistence.model.order.shell;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Transient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwe.GWEAppContext;
import org.gwe.drivers.fileSystems.staging.FileStagingException;
import org.gwe.drivers.fileSystems.staging.FilesStager;
import org.gwe.p2el.P2ELExpression;
import org.gwe.p2el.P2ELExpressionContext;
import org.gwe.p2el.P2ELFunction;
import org.gwe.p2el.P2ELSyntaxException;
import org.gwe.p2el.functions.FileStagingModel;
import org.gwe.p2el.functions.PFFileStageIn;
import org.gwe.p2el.functions.PFFileStageOut;
import org.gwe.persistence.model.EventType;
import org.gwe.persistence.model.JobInfo;
import org.gwe.persistence.model.ModelSummary;
import org.gwe.persistence.model.order.OrderRuntimeController;
import org.gwe.persistence.model.order.shell.OSCommandModel;
import org.gwe.persistence.model.order.shell.P2ELCommandsJobDescriptor;
import org.gwe.persistence.model.order.shell.ShellCommandDaemonRequest;
import org.gwe.utils.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class P2ELCommandJobInfo
extends JobInfo {
    private static Log log = LogFactory.getLog(P2ELCommandJobInfo.class);
    @Column(nullable=false, length=1024)
    private String command;
    @Transient
    private OSCommandModel cmdModel;

    public P2ELCommandJobInfo() {
    }

    public P2ELCommandJobInfo(String cmd, ShellCommandDaemonRequest<?> daemonRequest) {
        super(daemonRequest);
        this.command = cmd;
    }

    public String getCommand() {
        return this.command;
    }

    @Override
    public void preProcessInDaemon(OrderRuntimeController orderRC) throws Exception {
        this.cmdModel = this.createOSCommandModel(this.getFileStager(orderRC));
        this.cmdModel.prepare();
        ShellCommandDaemonRequest shellRequest = (ShellCommandDaemonRequest)this.request;
        shellRequest.extractLocalLink(this.runningDaemon.getHost());
        shellRequest.setWorkspacePath(this.getWorkspacePath());
        shellRequest.setOSCommand(this.cmdModel.getCommand());
    }

    private OSCommandModel createOSCommandModel(FilesStager fileStager) throws P2ELSyntaxException, FileStagingException {
        P2ELExpressionContext ctx = new P2ELExpressionContext(this.getWorkspacePath(), null);
        P2ELExpression expr = GWEAppContext.getP2ELEngine().createExpression(ctx, this.command);
        expr.compile();
        Map<String, String> downloads = this.extractFileTransfers(expr, PFFileStageIn.class, true);
        Map<String, String> uploads = this.extractFileTransfers(expr, PFFileStageOut.class, false);
        return new OSCommandModel(fileStager, expr.toString(), downloads, uploads);
    }

    private Map<String, String> extractFileTransfers(P2ELExpression expr, Class<? extends P2ELFunction> stageFunctionClass, boolean download) throws FileStagingException {
        HashMap<String, String> fileTransfers = new HashMap<String, String>();
        for (Object obj : expr.getCompilationModels(stageFunctionClass)) {
            if (!(obj instanceof FileStagingModel)) continue;
            FileStagingModel model = (FileStagingModel)obj;
            String fromFile = download ? model.getRemoteFile() : model.getLocalFile();
            String toFile = download ? model.getLocalFile() : model.getRemoteFile();
            fileTransfers.put(fromFile, toFile);
        }
        return fileTransfers;
    }

    @Override
    public void postProcessInDaemon(OrderRuntimeController orderRC) throws Exception {
        Object requestResult = this.getRequestResult();
        if (requestResult instanceof String) {
            requestResult = requestResult != null ? IOUtils.readFile(new File((String)requestResult)) : "";
        }
        this.setRequestResult((Serializable)requestResult);
        this.cmdModel.wrapUp();
        this.getFileStager(orderRC).cleanUp(this.getWorkspacePath());
    }

    private FilesStager getFileStager(OrderRuntimeController orderRC) {
        return ((P2ELCommandsJobDescriptor)orderRC.getOrder().getJobsDescriptor()).getFileStager();
    }

    @Override
    public ModelSummary<String> createModelSummaryFor(EventType ev) {
        return ev.equals((Object)EventType.CREATED) ? new ModelSummary<String>(this, new Serializable[]{this.command}) : super.createModelSummaryFor(ev);
    }
}

