/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.persistence.model.order.shell;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.gwe.drivers.fileSystems.staging.FilesStager;
import org.gwe.persistence.model.JobInfo;
import org.gwe.persistence.model.UserInfo;
import org.gwe.persistence.model.order.JobsDescriptor;
import org.gwe.persistence.model.order.OrderRuntimeController;
import org.gwe.persistence.model.order.shell.P2ELCommandJobInfo;
import org.gwe.persistence.model.order.shell.ShellCommandDaemonRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class P2ELCommandsJobDescriptor<DAEMON_REQUEST_PARAM_TYPE extends Serializable>
extends JobsDescriptor {
    protected DAEMON_REQUEST_PARAM_TYPE parameters = null;
    protected Class<? extends ShellCommandDaemonRequest> daemonRequestClass = ShellCommandDaemonRequest.class;
    private transient FilesStager fileStager;

    public void setDaemonRequestClassName(String clazzName) throws ClassNotFoundException {
        this.setDaemonRequestClass(Class.forName(clazzName));
    }

    public void setDaemonRequestClass(Class<? extends ShellCommandDaemonRequest<DAEMON_REQUEST_PARAM_TYPE>> daemonRequestClass) {
        this.daemonRequestClass = daemonRequestClass;
    }

    public void setParameters(DAEMON_REQUEST_PARAM_TYPE parameters) {
        this.parameters = parameters;
    }

    protected abstract String getCommandLines(UserInfo var1) throws Exception;

    @Override
    public final List<JobInfo> generateJobs(UserInfo user) throws Exception {
        ArrayList<JobInfo> results = new ArrayList<JobInfo>();
        for (String cmd : this.getCommandLines(user).split("\n")) {
            if (cmd == null || cmd.equals("")) continue;
            cmd = cmd.replaceAll("\t|\r|\n", " ").trim();
            try {
                ShellCommandDaemonRequest daemonRequest = this.daemonRequestClass.newInstance();
                daemonRequest.setParameters(this.parameters);
                results.add(new P2ELCommandJobInfo(cmd, daemonRequest));
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        return results;
    }

    public Class<? extends ShellCommandDaemonRequest> getDaemonRequestClass() {
        return this.daemonRequestClass;
    }

    public DAEMON_REQUEST_PARAM_TYPE getParameters() {
        return this.parameters;
    }

    @Override
    public void prepareForJobsExecution(OrderRuntimeController orderRC) {
        this.fileStager = new FilesStager(orderRC.getWorkspacePathInCluster(), orderRC.getOrder().getKeyStore());
    }

    @Override
    public void wrapUpJobsExecution(OrderRuntimeController orderRC) {
        this.fileStager.dispose();
    }

    public FilesStager getFileStager() {
        return this.fileStager;
    }
}

