/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.persistence.model.order.shell;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwe.GWEAppContext;
import org.gwe.drivers.HandleOperationException;
import org.gwe.drivers.netAccess.ConnectorException;
import org.gwe.drivers.netAccess.NetworkAccessHandle;
import org.gwe.drivers.netAccess.ShellCommand;
import org.gwe.persistence.model.order.DaemonRequest;
import org.gwe.utils.security.URILink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShellCommandDaemonRequest<DRP_TYPE extends Serializable>
extends DaemonRequest<DRP_TYPE> {
    private static Log log = LogFactory.getLog(ShellCommandDaemonRequest.class);
    protected String localizedCmd;
    protected String workspacePath;
    protected URILink localLink;

    public void setOSCommand(String localizedCmd) {
        this.localizedCmd = localizedCmd;
    }

    public void setWorkspacePath(String workspacePath) {
        this.workspacePath = workspacePath;
    }

    @Override
    public final Serializable process(String workspace) throws Exception {
        this.setup();
        String result = workspace + "result-" + this.jobId + ".out";
        FileOutputStream fos = null;
        try {
            log.info("Preparing daemon request execution.\n\tLocalized command: '" + this.localizedCmd + "' \n\tWorkspace: '" + this.workspacePath + "'");
            if (this.localizedCmd != null && !this.localizedCmd.equals("")) {
                ShellCommand cmd = new ShellCommand(this.localizedCmd, this.workspacePath, null);
                fos = new FileOutputStream(result, false);
                cmd.setOutputStream(fos);
                ((NetworkAccessHandle)GWEAppContext.getGridNetworkAccess().createHandle(this.localLink)).runCommand(cmd);
            }
        }
        catch (FileNotFoundException e) {
            log.warn("Result file could not be created", e);
        }
        catch (HandleOperationException e) {
            log.warn("IMPOSSIBLE");
        }
        catch (ConnectorException e) {
            log.fatal("IMPOSSIBLE");
        }
        if (fos != null) {
            try {
                fos.close();
            }
            catch (IOException e) {
                log.warn("Result file could not be closed", e);
            }
        }
        this.tearDown();
        return result;
    }

    protected Map<String, String> getEnvironment() {
        return new HashMap<String, String>();
    }

    protected void setup() {
    }

    protected void tearDown() {
    }

    protected String createUnderWorkspace(String fileName, String contents) {
        String fullFileName = this.workspacePath + fileName;
        try {
            FileOutputStream fos = new FileOutputStream(fullFileName, false);
            fos.write(contents.getBytes());
            return fullFileName;
        }
        catch (IOException e) {
            log.warn("Couldn't create file '" + fullFileName + "'", e);
            throw new RuntimeException("Exception thrown when agent tried to create a file for a job. Please contact developers", e);
        }
    }

    public void extractLocalLink(String host) {
        try {
            URILink headLink = this.keys.generateURILink(new URI("ssh://" + host));
            this.localLink = new URILink(headLink.getAccountInfo(), new URI("ssh://localhost"));
        }
        catch (URISyntaxException e) {
            log.fatal("IMPOSSIBLE");
        }
    }
}

