/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.utils;

import java.io.IOException;
import java.io.Serializable;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.gwe.utils.CompressionException;
import org.gwe.utils.IOUtils;

public class CompressedObject
implements Serializable {
    private int originalLength;
    private byte[] compressedObject = null;
    private Serializable targetObject = null;

    public CompressedObject() {
        this.nullTarget();
    }

    public CompressedObject(Serializable target) throws CompressionException {
        this.setTarget(target);
    }

    public void setTarget(Serializable target) throws CompressionException {
        if (target == null) {
            this.nullTarget();
            return;
        }
        byte[] source = this.serializeTarget(target);
        this.originalLength = source.length;
        byte[] compressedTarget = new byte[this.originalLength];
        Deflater compresser = new Deflater(5, true);
        compresser.setInput(source);
        compresser.finish();
        int length = compresser.deflate(compressedTarget);
        if (length == this.originalLength) {
            compressedTarget = null;
            this.targetObject = target;
        } else {
            this.compressedObject = new byte[length];
            System.arraycopy(compressedTarget, 0, this.compressedObject, 0, length);
        }
    }

    private byte[] serializeTarget(Serializable target) throws CompressionException {
        try {
            return IOUtils.serializeObject(target);
        }
        catch (IOException e) {
            throw new CompressionException(e);
        }
    }

    private void nullTarget() {
        this.compressedObject = null;
        this.targetObject = null;
    }

    public Serializable getTarget() throws CompressionException {
        if (this.targetObject != null) {
            return this.targetObject;
        }
        if (this.compressedObject == null) {
            return null;
        }
        byte[] result = new byte[this.originalLength];
        Inflater decompresser = new Inflater(true);
        decompresser.setInput(this.compressedObject, 0, this.compressedObject.length);
        try {
            decompresser.inflate(result);
            decompresser.end();
            return (Serializable)IOUtils.deserializeObject(result);
        }
        catch (Exception e) {
            throw new CompressionException(e);
        }
    }
}

