/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.utils;

import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Encryptor {
    private static Log log = LogFactory.getLog(Encryptor.class);
    private byte[] md5Hash;

    public static byte[] createMD5Hash(String key) {
        return Encryptor.createMD5Hash(key.getBytes());
    }

    public static byte[] createMD5Hash(byte[] key) {
        try {
            MessageDigest longHash = MessageDigest.getInstance("MD5");
            longHash.update(key);
            return longHash.digest();
        }
        catch (NoSuchAlgorithmException e) {
            log.fatal("Security not available because basic infrastructure to provide it is not available.", e);
            return null;
        }
    }

    public Encryptor(String password) {
        this(Encryptor.createMD5Hash(password));
    }

    public Encryptor(byte[] md5Bytes) {
        this.md5Hash = md5Bytes;
    }

    public String encrypt(byte[] target) throws Exception {
        Cipher cipher = this.createCipher(1);
        byte[] encryptedText = cipher.doFinal(target);
        return new String(Base64.encodeBase64(encryptedText));
    }

    public String decrypt(byte[] target) throws Exception {
        Cipher cipher = this.createCipher(2);
        byte[] decodedText = Base64.decodeBase64(target);
        return new String(cipher.doFinal(decodedText));
    }

    private Cipher createCipher(int mode) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        SecretKeySpec sk = new SecretKeySpec(this.md5Hash, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(mode, sk);
        return cipher;
    }

    public static void main(String[] args) throws Exception {
        Encryptor.test("user/password", "This is my message");
        Encryptor.test("user/password", ".This is my message");
        Encryptor.test("user/password", "This is my message-");
        Encryptor.test("user/password", "This is my messagee");
        Encryptor.test("user/password", "This is my message ");
        Encryptor.test("userpassword", "This is other message");
        Encryptor.test("user=password", "This is my message");
        Encryptor.test("user/password", "This is my message ");
        Encryptor.test("user/password", "This is other message, and it is far longer than the other ones. The $ ~~ 513443:;[]{} Its encrypted version should be longer as well, if not then it may just be a hashing function and not an actual encryptor");
        String pwd = "my-password";
        System.out.println("pwd: " + pwd);
        byte[] pwdHash = Encryptor.createMD5Hash(pwd);
        System.out.println("pwdHash: " + Encryptor.bytesToHex(pwdHash));
        String daemonPwd = pwd + "daemon-location";
        Encryptor enc = new Encryptor(daemonPwd);
        System.out.println("daemonPwd: " + daemonPwd);
        System.out.println("daemonPwdHash: " + Encryptor.bytesToHex(enc.md5Hash));
        String encPwdHash = enc.encrypt(pwdHash);
        System.out.println("encPwdHash: " + Encryptor.bytesToHex(encPwdHash));
        String decPwdHash = enc.decrypt(encPwdHash.getBytes());
        System.out.println("decPwdHash: " + Encryptor.bytesToHex(decPwdHash));
    }

    public static void test(String key, String message) throws Exception {
        System.out.println("Key: " + key);
        System.out.println("Message: " + message);
        Encryptor encrypter = new Encryptor(key);
        String enc = encrypter.encrypt(message.getBytes());
        System.out.println("Encrypted: " + Encryptor.bytesToHex(enc));
        System.out.println("Decrypted: " + encrypter.decrypt(enc.getBytes()) + "\n");
        System.out.println("Key Hash: " + Encryptor.bytesToHex(encrypter.md5Hash));
        String keyEnc = encrypter.encrypt(encrypter.md5Hash);
        System.out.println("Password encrypted with itself: " + Encryptor.bytesToHex(keyEnc));
        System.out.println("Password decrypted with itself: " + Encryptor.bytesToHex(encrypter.decrypt(keyEnc.getBytes())) + "\n");
    }

    public static String bytesToHex(String str) {
        return Encryptor.bytesToHex(str.getBytes());
    }

    public static String bytesToHex(byte[] b) {
        char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        StringBuffer buf = new StringBuffer();
        for (int j = 0; j < b.length; ++j) {
            buf.append(hexDigit[b[j] >> 4 & 0xF]);
            buf.append(hexDigit[b[j] & 0xF]);
        }
        return buf.toString();
    }
}

