/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IOUtils {
    private static Log log = LogFactory.getLog(IOUtils.class);

    public static String getFileBase(String uriStr) {
        String base = uriStr.replaceAll("[*?\\[].*", "");
        if (!base.endsWith("/")) {
            base = base.replaceFirst("/[^/]*$", "/");
        }
        return base;
    }

    public static String readFile(File f) throws FileNotFoundException, IOException {
        return IOUtils.readReader(new FileReader(f));
    }

    public static String readReader(InputStreamReader fr) throws IOException {
        StringBuffer sb = new StringBuffer();
        char[] buff = new char[1024];
        int num_read = fr.read(buff);
        while (num_read >= 0) {
            for (int ii = 0; ii < num_read; ++ii) {
                sb.append(buff[ii]);
            }
            num_read = fr.read(buff);
        }
        fr.close();
        return sb.toString();
    }

    public static byte[] readFile(String filename) throws IOException, FileNotFoundException {
        return IOUtils.readStream(new FileInputStream(new File(filename)), null).toByteArray();
    }

    public static String readClassPathFile(String fileName) {
        InputStream is = IOUtils.class.getClassLoader().getResourceAsStream(fileName);
        StringBuffer sb = new StringBuffer();
        try {
            int nextChar;
            while ((nextChar = is.read()) != -1) {
                sb.append((char)nextChar);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            is.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return sb.toString();
    }

    public static int pipeStreams(InputStream is, OutputStream os) throws IOException {
        return IOUtils.pipeStreams(is, os, false);
    }

    public static ByteArrayOutputStream readStream(InputStream is, OutputStream myOs) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        HashSet<OutputStream> osSet = new HashSet<OutputStream>();
        osSet.add(os);
        if (myOs != null) {
            osSet.add(myOs);
        }
        IOUtils.pipeStreams(is, osSet, false);
        return os;
    }

    public static int pipeStreams(InputStream is, OutputStream os, boolean closeStreams) throws IOException {
        HashSet<OutputStream> osSet = new HashSet<OutputStream>();
        osSet.add(os);
        return IOUtils.pipeStreams(is, osSet, closeStreams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int pipeStreams(InputStream is, Set<OutputStream> osSet, boolean closeStreams) throws IOException {
        long start = System.currentTimeMillis();
        int totalPiped = 0;
        BufferedInputStream in = null;
        HashSet<BufferedOutputStream> outs = new HashSet<BufferedOutputStream>();
        try {
            int amountRead;
            in = new BufferedInputStream(is);
            for (OutputStream os : osSet) {
                outs.add(new BufferedOutputStream(os));
            }
            byte[] buffer = new byte[65536];
            while ((amountRead = ((InputStream)in).read(buffer)) != -1) {
                for (BufferedOutputStream out : outs) {
                    out.write(buffer, 0, amountRead);
                    out.flush();
                }
                totalPiped += amountRead;
            }
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
            if (closeStreams) {
                for (BufferedOutputStream out : outs) {
                    out.close();
                }
            }
        }
        log.trace("Transfered " + totalPiped + " bytes.");
        long duration = System.currentTimeMillis() - start;
        return totalPiped;
    }

    public static <T> byte[] serializeObject(T obj) throws IOException {
        ByteArrayOutputStream resultOS = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(resultOS);
        out.writeObject(obj);
        return resultOS.toByteArray();
    }

    public static <T> T deserializeObject(byte[] stream) throws IOException, ClassNotFoundException {
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(stream));
        Object result = in.readObject();
        in.close();
        return (T)result;
    }
}

