/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.utils;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingConfigurer {
    private Map<String, String> levels;
    private String pattern;
    private boolean addConsoleAppender;
    private Set<String> logFiles;

    public void init() {
        for (String loggerName : this.levels.keySet()) {
            String levelName = this.levels.get(loggerName);
            try {
                Level level = Level.toLevel(levelName);
                Logger.getLogger(loggerName).setLevel(level);
            }
            catch (IllegalArgumentException e) {
                System.err.println("WARNING: Unable to parse '" + levelName + "' as a java.util.Level for logger " + loggerName + "; ignoring...");
            }
        }
        PatternLayout layoutObj = new PatternLayout(this.pattern);
        if (this.addConsoleAppender) {
            Logger.getRootLogger().addAppender(new ConsoleAppender(layoutObj));
        }
        for (String filename : this.logFiles) {
            try {
                Logger.getRootLogger().addAppender(new FileAppender((Layout)layoutObj, filename));
            }
            catch (IOException e) {
                System.err.println("WARNING: Unable to create file appender for log file '" + filename + "'; ignoring...");
            }
        }
    }

    public void setLevels(Map<String, String> props) {
        this.levels = props;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setAddConsoleAppender(boolean addConsoleAppender) {
        this.addConsoleAppender = addConsoleAppender;
    }

    public void setLogFiles(Set<String> logFiles) {
        this.logFiles = logFiles;
    }
}

