/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwe.utils.ConnectionTimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteResolver<RT extends Remote>
implements Runnable {
    private static Log log = LogFactory.getLog(RemoteResolver.class);
    private RT remoteObj = null;
    private String[] servicesList = null;
    private RemoteException rex = null;
    private NotBoundException nbex = null;
    private URI uriObj;
    private Thread resolverThread = null;
    private boolean list = false;
    private RMIClientSocketFactory socketFactory;

    public RemoteResolver(String uriStr, RMIClientSocketFactory socketFactory) throws URISyntaxException, UnknownHostException {
        this.uriObj = new URI(uriStr);
        this.socketFactory = socketFactory;
    }

    public RT getRemote(long waitMillis) throws RemoteException, NotBoundException, ConnectionTimeoutException {
        return (RT)((Remote)this.getRegistryInformation(waitMillis, false));
    }

    public String[] getList(long waitMillis) throws RemoteException, NotBoundException, ConnectionTimeoutException {
        return (String[])this.getRegistryInformation(waitMillis, true);
    }

    public synchronized <INFO_TYPE> INFO_TYPE getRegistryInformation(long waitMillis, boolean list) throws RemoteException, NotBoundException, ConnectionTimeoutException {
        long timeout;
        if (this.resolverThread != null) {
            return null;
        }
        this.list = list;
        this.resolverThread = new Thread(this);
        this.resolverThread.start();
        long end = System.currentTimeMillis() + waitMillis;
        while ((timeout = end - System.currentTimeMillis()) > 0L) {
            Object info;
            try {
                this.wait(timeout);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            Object object = info = list ? this.servicesList : this.remoteObj;
            if (info != null) {
                return (INFO_TYPE)info;
            }
            if (this.rex != null) {
                throw this.rex;
            }
            if (this.nbex == null) continue;
            throw this.nbex;
        }
        throw new ConnectionTimeoutException(this.uriObj.toString(), timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            log.info("Retrieving remote registry '" + this.uriObj.getHost() + ":" + this.uriObj.getPort() + "'...");
            Registry registry = LocateRegistry.getRegistry(this.uriObj.getHost(), this.uriObj.getPort(), this.socketFactory);
            log.info("Registry obtained! " + registry);
            log.info("Retrieving remote object '" + this.uriObj.toString() + "'...");
            Remote rObj = null;
            String[] sList = null;
            if (this.list) {
                sList = registry.list();
            } else {
                rObj = registry.lookup(this.uriObj.getPath().substring(1));
            }
            log.info("Remote proxy object created: '" + rObj + "'. Actual object at '" + this.uriObj.toString() + "'");
            RemoteResolver remoteResolver = this;
            synchronized (remoteResolver) {
                this.remoteObj = rObj;
                this.servicesList = sList;
                this.close();
            }
        }
        catch (RemoteException e) {
            RemoteResolver remoteResolver = this;
            synchronized (remoteResolver) {
                this.rex = e;
                this.close();
            }
        }
        catch (NotBoundException e) {
            RemoteResolver remoteResolver = this;
            synchronized (remoteResolver) {
                this.nbex = e;
                this.close();
            }
        }
    }

    private synchronized void close() {
        this.resolverThread = null;
        this.notifyAll();
    }
}

