/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.utils;

public class StringUtils {
    public static String getArrayAsStr(String[] array) {
        String result = " ";
        for (String arg : array) {
            result = result + arg + " ";
        }
        return result.trim();
    }

    public static String[] removeArgs(String[] args, int start, int count) {
        int idx;
        String[] trimmedArgs = new String[args.length - count];
        for (idx = 0; idx < start; ++idx) {
            trimmedArgs[idx] = args[idx];
        }
        for (idx = start + count; idx < args.length; ++idx) {
            trimmedArgs[idx - count] = args[idx];
        }
        return trimmedArgs;
    }

    public static String[] splitSpaceSeparated(String statement) {
        return statement.split("\\p{javaWhitespace}+");
    }

    public static String[] splitBoundaries(String whole, String startToken, String endToken) {
        return StringUtils.splitBoundaries(whole, startToken, endToken, null);
    }

    public static String[] splitBoundaries(String whole, String startToken, String endToken, String endTokenCancelator) {
        int startIndex = whole.indexOf(startToken);
        if (startIndex == -1) {
            return null;
        }
        String result = whole.substring(startIndex + startToken.length());
        int endIndex = StringUtils.getCorrespondingEndTokenIndex(result, endToken, endTokenCancelator);
        if (endIndex == -1) {
            return null;
        }
        return new String[]{whole.substring(0, startIndex), startToken, result.substring(0, endIndex), endToken, result.substring(endIndex + endToken.length())};
    }

    private static int getCorrespondingEndTokenIndex(String result, String endToken, String endTokenCancelator) {
        if (endTokenCancelator == null) {
            return result.indexOf(endToken);
        }
        int endIndex = 0;
        int endTokensCount = 0;
        while ((endIndex = result.indexOf(endToken, endIndex)) != -1) {
            int cancelatorsCount = StringUtils.getTokenCounts(result.substring(0, endIndex), endTokenCancelator);
            if (cancelatorsCount == ++endTokensCount - 1) {
                return endIndex;
            }
            endIndex += endTokenCancelator.length();
        }
        return -1;
    }

    private static int getTokenCounts(String result, String endTokenCancelator) {
        int count = 0;
        int index = 0;
        while ((index = result.indexOf(endTokenCancelator, index)) != -1) {
            index += endTokenCancelator.length();
            ++count;
        }
        return count;
    }

    public static void main(String[] args) {
        String[] splitted;
        for (String str : splitted = StringUtils.splitBoundaries("123abcdefghi456", "ab", "gh")) {
            System.out.println(str);
        }
        String[] splitted1 = StringUtils.splitBoundaries("myFile=$gwe:out(http://myhost/$gwe:anon([10..100||20]))$gwe:what()", "$gwe:out(", ")", "(");
        String[] splitted3 = StringUtils.splitBoundaries("--file $P2EL:stage(in(a, b, c),http://myfile) --file2", "$P2EL:stage(", ")", "(");
        System.out.println();
        for (String str : splitted3) {
            System.out.println(str);
        }
        String[] splitted4 = StringUtils.splitBoundaries(splitted3[2], "(", ")");
        System.out.println();
        for (String str : splitted4) {
            System.out.println(str);
        }
    }
}

