/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.utils.cmd;

import java.util.ArrayList;
import java.util.List;

public class OptionParser {
    private List<String> parts;

    public OptionParser(String prefix, String arg, char[] separators) {
        this.parts = new ArrayList<String>(separators.length + 1);
        if (arg == null || !arg.startsWith(prefix)) {
            return;
        }
        String partsArg = arg.substring(prefix.length());
        for (int idx = separators.length - 1; idx >= 0; --idx) {
            String value = null;
            int sepIndex = partsArg.lastIndexOf(separators[idx]);
            if (sepIndex != -1) {
                value = partsArg.substring(sepIndex + 1);
                partsArg = partsArg.substring(0, sepIndex);
            }
            this.parts.add(0, value);
        }
        this.parts.add(0, partsArg);
    }

    public String getEle(int index, String defaultValue) {
        if (index > this.parts.size() - 1) {
            return defaultValue;
        }
        String result = this.parts.get(index);
        return result != null && !"".equals(result) ? result : defaultValue;
    }

    public static void main(String[] args) {
        OptionParser parser = new OptionParser("prefix=", "prefix=alfa:gama:delta@whatever-now:end", new char[]{':', ':', '@', '-', ':'});
        System.out.println(parser.getEle(0, null));
        System.out.println(parser.getEle(1, null));
        System.out.println(parser.getEle(2, null));
        System.out.println(parser.getEle(3, null));
        System.out.println(parser.getEle(4, null));
        System.out.println(parser.getEle(5, null));
        System.out.println(parser.getEle(6, null));
        System.out.println(parser.getEle(7, null));
    }
}

