/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.utils.cmd;

import java.util.ArrayList;
import org.springframework.beans.BeanWrapper;

public class OptionTemplate {
    private static final char NO_SHORT_FLAG = '-';
    private char shortFlag = (char)45;
    private String longFlag;
    private String description;
    private String defaultValue;
    private String propertyName = null;
    private String toString;

    public OptionTemplate(String longFlag, String description) {
        this(longFlag, '-', longFlag, description, null);
    }

    public OptionTemplate(String longFlag, String description, String defVal) {
        this(longFlag, '-', longFlag, description, defVal);
    }

    public OptionTemplate(char shortFlag, String longFlag, String description) {
        this(longFlag, shortFlag, longFlag, description, null);
    }

    public OptionTemplate(char shortFlag, String longFlag, String description, String defVal) {
        this(longFlag, shortFlag, longFlag, description, defVal);
    }

    public OptionTemplate(String propName, String longFlag, String description, String defVal) {
        this(propName, '-', longFlag, description, defVal);
    }

    public OptionTemplate(String propName, char shortFlag, String longFlag, String description) {
        this(propName, shortFlag, longFlag, description, null);
    }

    public OptionTemplate(String propName, char shortFlag, String longFlag, String description, String defVal) {
        this.propertyName = propName;
        this.shortFlag = shortFlag;
        this.longFlag = longFlag;
        this.description = description;
        this.defaultValue = defVal;
        this.toString = this.createToString("\t\t");
    }

    private String createToString(String filler) {
        String shortDesc = this.shortFlag != '-' ? "\t-" + this.shortFlag + ", " : "";
        return shortDesc + "--" + this.longFlag + filler + this.getFullDescription() + "\n";
    }

    private String getFullDescription() {
        String defValMsg = this.defaultValue != null && !this.defaultValue.equals("") ? "Defaults to '" + this.defaultValue + "'" : "No default value";
        return this.description + ". " + defValMsg + ".";
    }

    public char getShortFlag() {
        return this.shortFlag;
    }

    public String getLongFlag() {
        return this.longFlag;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setObjectProperty(BeanWrapper appObjectWrapper, Object value) {
        if (this.propertyName == null) {
            return;
        }
        appObjectWrapper.setPropertyValue(this.propertyName, value);
    }

    public String readOptionValue(String[] args) {
        return this.readOptionValue(args, this.defaultValue);
    }

    public String readOptionValue(String[] args, String defaultValue) {
        String res = this.readUnformattedOptionValue(args, defaultValue);
        if (res == null) {
            return res;
        }
        return res.matches("^\".*\"$") ? res.substring(1, res.length() - 1) : res;
    }

    private String readUnformattedOptionValue(String[] args, String defaultValue) {
        String currArg;
        int idx;
        String longName = "--" + this.longFlag;
        String shortName = this.shortFlag != '-' ? "-" + this.shortFlag : null;
        for (idx = 0; idx < args.length; ++idx) {
            currArg = args[idx];
            if (!currArg.equals(longName) && !currArg.equals(shortName)) continue;
            return this.hasValueAssigned(args, idx) ? args[idx + 1] : "";
        }
        for (idx = 0; idx < args.length; ++idx) {
            currArg = args[idx];
            if (!this.startsWith(currArg, longName, shortName)) continue;
            return currArg.substring(currArg.indexOf("=") + 1);
        }
        return defaultValue;
    }

    public String[] removeOptionFromArray(String[] args) {
        ArrayList<String> results = new ArrayList<String>();
        String longName = "--" + this.longFlag;
        String shortName = this.shortFlag != '-' ? "-" + this.shortFlag : null;
        for (int idx = 0; idx < args.length; ++idx) {
            String currArg = args[idx];
            if (currArg.equals(longName) || currArg.equals(shortName)) {
                if (!this.hasValueAssigned(args, idx)) continue;
                ++idx;
                continue;
            }
            if (this.startsWith(currArg, longName, shortName)) continue;
            results.add(currArg);
        }
        return results.toArray(new String[0]);
    }

    private boolean hasValueAssigned(String[] args, int index) {
        if (args.length <= index + 1) {
            return false;
        }
        String arg = args[index + 1];
        if (arg.length() == 0) {
            return true;
        }
        if (arg.charAt(0) == '-') {
            try {
                Double.parseDouble(arg);
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    private boolean startsWith(String currArg, String longName, String shortName) {
        return currArg.startsWith(longName + "=") || shortName != null && currArg.startsWith(shortName + "=");
    }

    public String toString() {
        return this.toString;
    }

    public String toString(int longFlagSize) {
        return this.createToString(this.createFiller(longFlagSize));
    }

    private String createFiller(int longFlagSize) {
        String filler = "";
        for (int count = 0; count < longFlagSize - this.longFlag.length(); ++count) {
            filler = filler + " ";
        }
        return filler;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OptionTemplate)) {
            return false;
        }
        return ((OptionTemplate)obj).getLongFlag().equals(this.longFlag);
    }

    public int hashCode() {
        return this.toString.hashCode();
    }
}

