/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.utils.cmd;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gwe.utils.StringUtils;
import org.gwe.utils.cmd.OptionTemplate;
import org.springframework.beans.BeanWrapperImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionableAppTemplate {
    public final OptionTemplate OPT_HELP = new OptionTemplate('h', "help", "Help. Displays command usage");
    public final OptionTemplate OPT_INTERACT = new OptionTemplate("interactive", "Runs application in interactive mode, requesting the parameters to the user one by one.");
    private List<OptionTemplate> templatesInOrder = new ArrayList<OptionTemplate>();
    private Map<OptionTemplate, String> options = new HashMap<OptionTemplate, String>();

    public OptionableAppTemplate() {
        this.options.put(this.OPT_HELP, null);
        this.options.put(this.OPT_INTERACT, null);
    }

    public OptionableAppTemplate(OptionTemplate ... templates) {
        this();
        this.addOptions(templates);
    }

    public OptionableAppTemplate addOptions(OptionTemplate ... options) {
        for (OptionTemplate template : options) {
            this.addOption(template, template.getDefaultValue());
        }
        return this;
    }

    public void resetArgs() {
        this.addOptions(this.templatesInOrder.toArray(new OptionTemplate[0]));
    }

    public OptionTemplate addArg(OptionTemplate template) {
        return this.addOption(template, template.getDefaultValue());
    }

    public OptionTemplate addOption(OptionTemplate template, Object value) {
        this.templatesInOrder.remove(template);
        this.templatesInOrder.add(template);
        String strVal = value != null ? value.toString() : null;
        this.options.put(template, strVal);
        return template;
    }

    public void removeOption(OptionTemplate template) {
        this.templatesInOrder.remove(template);
        this.options.remove(template);
    }

    public String[] getInvocationArgs() {
        ArrayList<String> result = new ArrayList<String>();
        for (OptionTemplate template : this.templatesInOrder) {
            result.add("-" + String.valueOf(template.getShortFlag()));
            result.add(this.options.get(template));
        }
        return result.toArray(new String[0]);
    }

    public <APP_TYPE> APP_TYPE loadArgs(String[] args, APP_TYPE appObject) {
        this.loadArgs(args);
        return this.populateAppObject(appObject);
    }

    public void loadArgs(String[] args) {
        this.resetArgs();
        for (OptionTemplate option : this.options.keySet()) {
            this.options.put(option, option.readOptionValue(args));
        }
        if (this.getArg(this.OPT_HELP) != null) {
            System.out.println(this.getUsage());
            System.exit(0);
        }
        if (this.getArg(this.OPT_INTERACT) != null) {
            System.out.println("PLEASE ENTER THE PARAMETERS AS THEY ARE REQUESTED.\nTo use a field's default value just leave it blank and press return.\n======================================================================");
            for (OptionTemplate option : this.templatesInOrder) {
                this.readOptionFromConsole(option);
            }
        }
    }

    public String[] getWithoutOptionsArgs(String[] args) {
        for (OptionTemplate option : this.options.keySet()) {
            args = option.removeOptionFromArray(args);
        }
        return args;
    }

    public String getWithoutOptionsArgsAsStr(String[] args) {
        return StringUtils.getArrayAsStr(this.getWithoutOptionsArgs(args));
    }

    private void readOptionFromConsole(OptionTemplate option) {
        try {
            String value = this.readNextField(option.getDescription() + "\n" + option.getLongFlag());
            if (value == null || "".equals(value)) {
                value = option.getDefaultValue();
            }
            this.options.put(option, value);
        }
        catch (IOException e) {
            System.out.print("There was an IO error trying to collect your information. The application will use the default value of " + option.getDefaultValue() + " for " + option.getLongFlag());
        }
    }

    public String getArg(OptionTemplate key) {
        return this.options.get(key);
    }

    public Integer getArgAsInt(OptionTemplate key) {
        try {
            return Integer.parseInt(this.options.get(key));
        }
        catch (Exception e) {
            return null;
        }
    }

    public Long getArgAsLong(OptionTemplate key) {
        try {
            return Long.parseLong(this.options.get(key));
        }
        catch (Exception e) {
            return null;
        }
    }

    public <APP_TYPE> APP_TYPE populateAppObject(APP_TYPE appObject) {
        BeanWrapperImpl appObjectWrapper = new BeanWrapperImpl(appObject);
        for (OptionTemplate template : this.templatesInOrder) {
            template.setObjectProperty(appObjectWrapper, this.options.get(template));
        }
        return appObject;
    }

    public String getUsage() {
        String usage = "Usage: java " + this.getClass().getName() + " [OPTION]\n\nOptions:\n";
        int longFlagSize = 0;
        for (OptionTemplate option : this.templatesInOrder) {
            longFlagSize = Math.max(longFlagSize, option.getLongFlag().length());
        }
        for (OptionTemplate option : this.templatesInOrder) {
            usage = usage + option.toString(longFlagSize);
        }
        return usage;
    }

    public String toString() {
        return this.getUsage();
    }

    private String readNextField(String fieldName) throws IOException {
        System.out.print(fieldName + ": ");
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        String line = reader.readLine();
        if (line == null) {
            return null;
        }
        return line;
    }

    public OptionableAppTemplate clone() {
        OptionableAppTemplate result = new OptionableAppTemplate(this.templatesInOrder.toArray(new OptionTemplate[0]));
        result.options.putAll(this.options);
        return result;
    }
}

