/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.utils.concurrent;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockingList<ELE_TYPE> {
    private List<ELE_TYPE> wrapee = new ArrayList<ELE_TYPE>();

    public synchronized List<ELE_TYPE> copy() {
        return new ArrayList<ELE_TYPE>(this.wrapee);
    }

    public synchronized void add(ELE_TYPE element) {
        this.wrapee.add(element);
        this.notifyAll();
    }

    public synchronized void remove(ELE_TYPE element) {
        this.wrapee.remove(element);
    }

    public synchronized List<ELE_TYPE> takeAll() {
        this.waitUntilNotEmpty();
        List<ELE_TYPE> containerCopy = this.copy();
        this.wrapee.clear();
        return containerCopy;
    }

    public synchronized ELE_TYPE takeOne() {
        ELE_TYPE result;
        do {
            this.waitUntilNotEmpty();
        } while ((result = this.wrapee.remove(0)) == null);
        return result;
    }

    private void waitUntilNotEmpty() {
        while (this.wrapee.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public int size() {
        return this.wrapee.size();
    }
}

