/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.utils.concurrent;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockingMap<KEY_TYPE, ELE_TYPE> {
    private Map<KEY_TYPE, ELE_TYPE> wrapee = new HashMap<KEY_TYPE, ELE_TYPE>();

    public synchronized void put(KEY_TYPE id, ELE_TYPE value) {
        this.wrapee.put(id, value);
        this.notifyAll();
    }

    public synchronized ELE_TYPE remove(KEY_TYPE key) {
        return this.wrapee.remove(key);
    }

    public synchronized Map<KEY_TYPE, ELE_TYPE> takeAll() {
        this.waitUntilNotEmpty();
        HashMap<KEY_TYPE, ELE_TYPE> copy = new HashMap<KEY_TYPE, ELE_TYPE>();
        for (KEY_TYPE id : this.wrapee.keySet()) {
            copy.put(id, this.wrapee.get(id));
        }
        return copy;
    }

    public synchronized ELE_TYPE takeOne() {
        this.waitUntilNotEmpty();
        return this.wrapee.remove(this.wrapee.keySet().iterator().next());
    }

    private void waitUntilNotEmpty() {
        while (this.wrapee.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public int size() {
        return this.wrapee.size();
    }
}

