/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.utils.concurrent;

import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwe.utils.concurrent.BooleanLock;
import org.gwe.utils.concurrent.HeartBeater;
import org.gwe.utils.concurrent.ThreadPoolUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Heart<HEART_CONTAINER_TYPE>
implements Runnable {
    private static Log log = LogFactory.getLog(Heart.class);
    private static ExecutorService heartsThreadPool = ThreadPoolUtils.createThreadPool("Hearts", true);
    private Object id;
    private HEART_CONTAINER_TYPE heartBody;
    private HeartBeater<HEART_CONTAINER_TYPE> beater;
    private int period;
    private long lastHeartBeat = System.currentTimeMillis();
    private BooleanLock pauseLock = new BooleanLock();
    private boolean mustStop = false;

    public Heart(Object id, HEART_CONTAINER_TYPE heartBody, HeartBeater<HEART_CONTAINER_TYPE> beater, int period) {
        this.id = id;
        this.heartBody = heartBody;
        this.beater = beater;
        this.period = period;
        heartsThreadPool.submit(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        BooleanLock booleanLock = this.pauseLock;
        synchronized (booleanLock) {
            log.trace("Stopping: [id=" + this.id + ", body=" + this.heartBody + "]");
            this.mustStop = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        BooleanLock booleanLock = this.pauseLock;
        synchronized (booleanLock) {
            log.trace("Pausing: [id=" + this.id + ", body=" + this.heartBody + "]");
            this.pauseLock.applyLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        BooleanLock booleanLock = this.pauseLock;
        synchronized (booleanLock) {
            log.trace("Resuming: [id=" + this.id + ", body=" + this.heartBody + "]");
            this.pauseLock.releaseLock();
            this.resetLastHeartBeat();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetLastHeartBeat() {
        BooleanLock booleanLock = this.pauseLock;
        synchronized (booleanLock) {
            this.lastHeartBeat = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long timeToNextBeat = 0L;
        while (true) {
            BooleanLock booleanLock = this.pauseLock;
            synchronized (booleanLock) {
                if (this.mustStop) {
                    log.trace("Disposing: [id=" + this.id + ", body=" + this.heartBody + "]");
                    return;
                }
                this.pauseLock.waitUntilConditionTrue();
                log.trace("Pause lock released: [id=" + this.id + ", body=" + this.heartBody + "]");
                timeToNextBeat = this.lastHeartBeat + (long)this.period - System.currentTimeMillis();
                if (timeToNextBeat <= 0L) {
                    log.trace("Heart beating: [id=" + this.id + ", body=" + this.heartBody + "]");
                    if (this.beater == null || this.beater.beatAndReportIfMustContinue(this.id, this.heartBody)) {
                        this.resetLastHeartBeat();
                    }
                    timeToNextBeat = this.period;
                }
            }
            try {
                Thread.sleep(timeToNextBeat);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

