/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.utils.concurrent;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwe.utils.concurrent.Heart;
import org.gwe.utils.concurrent.HeartBeater;
import org.gwe.utils.concurrent.PulsingServerAPI;
import org.springframework.aop.Pointcut;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.aop.support.StaticMethodMatcherPointcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PulsingServerAPIProxyCreator<HEART_CONTAINER_TYPE> {
    private static Log log = LogFactory.getLog(PulsingServerAPIProxyCreator.class);
    private static final Pointcut pointcut = new StaticMethodMatcherPointcut(){

        public boolean matches(Method method, Class targetClass) {
            boolean preliminaryTest;
            boolean bl = preliminaryTest = PulsingServerAPI.class.isAssignableFrom(targetClass) && Modifier.isPublic(method.getModifiers()) && !method.getName().equals("heartBeat");
            if (preliminaryTest) {
                for (Class<?> excType : method.getExceptionTypes()) {
                    if (!RemoteException.class.isAssignableFrom(excType)) continue;
                    return true;
                }
            }
            return false;
        }
    };
    private Map<Object, Heart<HEART_CONTAINER_TYPE>> hearts = new HashMap<Object, Heart<HEART_CONTAINER_TYPE>>();
    private int period;
    private HeartBeater<HEART_CONTAINER_TYPE> beater;

    public static <PROXIED_TYPE> PROXIED_TYPE createProxyIfNecessary(PROXIED_TYPE proxiedObject, HeartBeater<?> beater) {
        return proxiedObject instanceof PulsingServerAPI && beater != null ? new PulsingServerAPIProxyCreator(beater).createProxy(proxiedObject) : proxiedObject;
    }

    public PulsingServerAPIProxyCreator(HeartBeater<HEART_CONTAINER_TYPE> beater) {
        this(beater, 60000);
    }

    public PulsingServerAPIProxyCreator(HeartBeater<HEART_CONTAINER_TYPE> beater, int period) {
        this.beater = beater;
        this.period = period;
    }

    public void stop(Object id) {
        this.getHeart(id, null).stop();
    }

    public void resetLastHeartBeat(Object id, HEART_CONTAINER_TYPE heartContainer) {
        this.getHeart(id, heartContainer).resetLastHeartBeat();
    }

    public <PROXIED_TYPE> PROXIED_TYPE createProxy(PROXIED_TYPE proxiedObject) {
        ProxyFactory factory = new ProxyFactory(proxiedObject);
        factory.addAdvisor(new DefaultPointcutAdvisor(pointcut, new PulsingMethodInterceptor(proxiedObject)));
        return (PROXIED_TYPE)factory.getProxy();
    }

    private Heart<HEART_CONTAINER_TYPE> getHeart(Object id, HEART_CONTAINER_TYPE heartContainer) {
        Heart<HEART_CONTAINER_TYPE> result = this.hearts.get(id);
        if (result == null) {
            result = new Heart<HEART_CONTAINER_TYPE>(id, heartContainer, this.beater, this.period);
            this.hearts.put(id, result);
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PulsingMethodInterceptor<PROXIED_TYPE>
    implements MethodInterceptor {
        private final PROXIED_TYPE proxiedObject;
        private final Class<? extends Object> proxiedClass;

        private PulsingMethodInterceptor(PROXIED_TYPE proxiedObject) {
            this.proxiedObject = proxiedObject;
            this.proxiedClass = proxiedObject.getClass();
        }

        @Override
        public Object invoke(MethodInvocation invocation) throws Throwable {
            Object id = invocation.getArguments()[0];
            Heart heart = PulsingServerAPIProxyCreator.this.getHeart(id, invocation.getThis());
            heart.pause();
            String methodName = invocation.getMethod().getName();
            log.info("AOP for " + this.proxiedClass + ". Invoking '" + methodName + "'  for entity '" + id + "' with arguments (" + this.argsToString(invocation) + ") ...");
            Object result = invocation.proceed();
            log.info("AOP for " + this.proxiedClass + ". '" + methodName + "' invoked for entity '" + id + "' ! Return value: \n" + result);
            heart.resume();
            return result;
        }

        private String argsToString(MethodInvocation invocation) {
            String args = "";
            Object[] array = invocation.getArguments();
            for (int idx = 1; idx < array.length; ++idx) {
                args = args + array[idx] + ";";
            }
            return args;
        }
    }
}

