/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.utils.concurrent;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class ThreadPoolUtils {
    public static ExecutorService createThreadPool(String name) {
        return ThreadPoolUtils.createThreadPool(name, false);
    }

    public static ExecutorService createThreadPool(final String name, final boolean daemon) {
        ThreadFactory threadFactory = new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread result = Executors.defaultThreadFactory().newThread(r);
                String oldName = result.getName();
                String counter = oldName.substring(oldName.indexOf("-") + 1, oldName.indexOf("-thread"));
                result.setName("TP: " + name + " # " + counter);
                result.setDaemon(daemon);
                return result;
            }
        };
        return Executors.newCachedThreadPool(threadFactory);
    }
}

