/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.utils.security;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.gssapi.GlobusGSSManagerImpl;
import org.gwe.utils.IOUtils;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;

public class AccountInfo
implements Serializable {
    private static Log log = LogFactory.getLog(AccountInfo.class);
    private static final String MISSING_VALUE = "?";
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final AccountInfo NO_AUTH_ACCOUNT = new AccountInfo("Account without authentication", "", "");
    private String accountName;
    private String userName;
    private String homeDir;
    private String spoolDir = null;
    private Properties props = new Properties();
    private String password = null;
    private String passphrase = null;
    private byte[] privateKey = null;
    private byte[] publicKey = null;
    private GSSCredential credential;

    public static AccountInfo createLocalAccount() {
        return new AccountInfo("Local Account", System.getProperty("user.name"), System.getProperty("user.home"));
    }

    public AccountInfo(String accountName, String user, String homeDir, String passphrase, String privateKeyFilename, String publicKeyFilename) throws FileNotFoundException, IOException {
        this(accountName, user, homeDir, passphrase, IOUtils.readFile(privateKeyFilename), IOUtils.readFile(publicKeyFilename));
    }

    public AccountInfo(String accountName, String user, String homeDir, String passphrase, byte[] privateKey, byte[] publicKey) {
        this(accountName, user, homeDir);
        this.passphrase = "".equals(passphrase) ? null : passphrase;
        this.privateKey = privateKey;
        this.publicKey = publicKey;
    }

    public AccountInfo(String accountName, String user, String homeDir, String password) {
        this(accountName, user, homeDir);
        this.password = password == null ? "" : password;
    }

    private AccountInfo(String accountName, String userName, String homeDir) {
        this.accountName = accountName;
        this.userName = userName;
        this.homeDir = homeDir;
    }

    public String getSpoolDir() {
        return this.spoolDir;
    }

    public void setSpoolDir(String spoolDir) {
        this.spoolDir = spoolDir;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getHomeDir() {
        return this.homeDir;
    }

    public String getProperty(String propName) {
        return this.props.getProperty(propName);
    }

    public void setProperties(Properties properties) {
        this.props = properties;
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    public byte[] getPrivateKey() {
        return this.privateKey == null ? this.privateKey : (byte[])this.privateKey.clone();
    }

    public byte[] getPublicKey() {
        return this.publicKey == null ? this.publicKey : (byte[])this.publicKey.clone();
    }

    public String getPassword() {
        return this.password;
    }

    public GSSCredential getCredential() {
        return this.credential;
    }

    public void setCredential(GSSCredential credential) {
        this.credential = credential;
    }

    public void setCredential(String proxyStr) throws GSSException {
        GlobusGSSManagerImpl mgr = new GlobusGSSManagerImpl();
        this.credential = mgr.createCredential(proxyStr.getBytes(), 0, 0, null, 2);
    }

    public String getWorkspacePath() {
        String fsRootDir = this.spoolDir;
        if (fsRootDir == null) {
            fsRootDir = this.homeDir;
        }
        if (!fsRootDir.endsWith(FILE_SEPARATOR)) {
            fsRootDir = fsRootDir + FILE_SEPARATOR;
        }
        return fsRootDir + ".gwe-vfs";
    }

    public AccountInfo clone() {
        return this.password != null ? new AccountInfo(this.accountName, this.userName, this.homeDir, this.password) : new AccountInfo(this.accountName, this.userName, this.homeDir, this.passphrase, this.privateKey, this.publicKey);
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPassphrase(String passphrase) {
        this.passphrase = passphrase;
    }

    public boolean missingPassword() {
        return MISSING_VALUE.equals(this.password);
    }

    public boolean missingPassphrase() {
        return MISSING_VALUE.equals(this.passphrase);
    }
}

