/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.utils.security;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwe.utils.security.AccountInfo;
import org.gwe.utils.security.CredentialNotFoundException;
import org.gwe.utils.security.Realm;
import org.gwe.utils.security.URILink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyStore
implements Serializable {
    private static Log log = LogFactory.getLog(KeyStore.class);
    private List<Realm> realms = new ArrayList<Realm>();

    public static KeyStore createKeyStore(String domain, String username, String homeDir, String password) {
        AccountInfo account = new AccountInfo("Programatically Created Account", username, homeDir, password);
        Realm realm = new Realm("ssh;sftp", domain);
        realm.setAccount(account);
        ArrayList<Realm> realms = new ArrayList<Realm>();
        realms.add(realm);
        KeyStore result = new KeyStore();
        result.setRealms(realms);
        return result;
    }

    public List<Realm> getRealms() {
        return this.realms;
    }

    public void setRealms(List<Realm> realms) {
        this.realms = realms;
    }

    public URILink generateURILink(String uriStr) throws URISyntaxException {
        return this.generateURILink(new URI(uriStr));
    }

    public URILink generateURILink(URI uri) {
        return uri == null ? new URILink(AccountInfo.createLocalAccount(), null) : new URILink(this.getAccountForURI(uri), uri);
    }

    public void verifyCredentials() throws CredentialNotFoundException {
        for (Realm realm : this.realms) {
            if (!realm.getAccount().equals(AccountInfo.NO_AUTH_ACCOUNT)) continue;
            throw new CredentialNotFoundException(realm.toString());
        }
    }

    public AccountInfo getAccountForURI(URI uri) {
        return this.getAccountForRealm(new Realm(uri));
    }

    public AccountInfo getAccountForRealm(Realm someRealm) {
        for (Realm currRealm : this.realms) {
            if (!currRealm.containsRealm(someRealm)) continue;
            return currRealm.getAccount();
        }
        return null;
    }
}

