/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.utils.security;

import java.io.Serializable;
import java.net.URI;
import java.util.Arrays;
import org.gwe.utils.security.AccountInfo;

public class Realm
implements Serializable {
    private String[] schemes = new String[0];
    private String[] domains = new String[0];
    private AccountInfo account;

    private static String[] semicolonSplitted(String target) {
        return target != null ? target.split(";") : new String[]{};
    }

    public Realm() {
    }

    Realm(URI uri) {
        this(uri.getScheme(), uri.getHost());
    }

    public Realm(String schemes, String domains, String user, String homeDir, String password) {
        this(schemes, domains, new AccountInfo("Account created for domains " + domains, user, homeDir, password));
    }

    public Realm(String schemes, String domains, AccountInfo account) {
        this(schemes, domains);
        this.setAccount(account);
    }

    public Realm(String scheme, String domain) {
        this(Realm.semicolonSplitted(scheme), Realm.semicolonSplitted(domain));
    }

    private Realm(String[] scheme, String[] domain) {
        this.schemes = scheme;
        this.domains = domain;
    }

    public AccountInfo getAccount() {
        return this.account;
    }

    public void setAccount(AccountInfo auth) {
        this.account = auth;
    }

    public boolean containsRealm(Realm realmObj) {
        for (String protocol : realmObj.schemes) {
            if (Arrays.asList(this.schemes).contains(protocol)) continue;
            return false;
        }
        for (String domain : realmObj.domains) {
            if (this.impliesDomain(domain)) continue;
            return false;
        }
        return true;
    }

    private boolean impliesDomain(String domain) {
        String[] hostParts = domain.split("\\.");
        for (int ii = 0; ii < hostParts.length; ++ii) {
            String hostStr = ii == 0 ? "" : "*";
            for (int jj = ii; jj < hostParts.length; ++jj) {
                hostStr = hostStr.length() != 0 ? hostStr + "." + hostParts[jj] : hostParts[jj];
            }
            if (!Arrays.asList(this.domains).contains(hostStr)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return Realm.toString(this.schemes) + "://" + Realm.toString(this.domains);
    }

    public static String toString(String[] array) {
        boolean started = false;
        String result = "";
        for (String ele : array) {
            if (started) {
                result = result + ";";
            }
            result = result + ele;
            started = true;
        }
        return result;
    }

    public Realm clone() {
        Realm result = new Realm(this.schemes, this.domains);
        result.setAccount(this.account.clone());
        return result;
    }
}

